/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.armors;

import com.sofodev.armorplus.api.caps.abilities.MaterialType;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;

public enum Tier implements IStringSerializable
{
    TIER_0("none", 0, MaterialType.NONE),
    TIER_1("beginner", 8, MaterialType.COAL, MaterialType.LAPIS, MaterialType.REDSTONE, MaterialType.CHICKEN, MaterialType.SLIME),
    TIER_2("amateur", 16, MaterialType.EMERALD, MaterialType.OBSIDIAN, MaterialType.INFUSED_LAVA, MaterialType.ARDITE, MaterialType.COBALT, MaterialType.KNIGHT_SLIME, MaterialType.PIG_IRON),
    TIER_3("master", 30, MaterialType.GUARDIAN, MaterialType.SUPER_STAR, MaterialType.ENDER_DRAGON, MaterialType.MANYULLYN),
    TIER_4("grandmaster", 60, MaterialType.ULTIMATE);

    private final String name;
    private final int enchantability;
    private final MaterialType[] materials;

    private Tier(String name, int enchantability, MaterialType ... materials) {
        this.name = name;
        this.materials = materials;
        this.enchantability = enchantability;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public MaterialType[] getMaterials() {
        return this.materials;
    }

    public Tier getTier() {
        return this;
    }

    public Tier getTier(String name) {
        return Arrays.stream(Tier.values()).filter(tier -> tier.func_176610_l().equals(name)).findFirst().orElse(this);
    }

    public Tier getTier(MaterialType material) {
        return Arrays.stream(Tier.values()).filter(tier -> Arrays.stream(tier.getMaterials()).anyMatch(mat -> mat == material)).findFirst().orElse(this);
    }

    public int getEnchantability() {
        return this.enchantability;
    }
}

