/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.events;

import com.sofodev.armorplus.common.compat.draconicevolution.DEUtils;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemSpecialArmor;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemUltimateArmor;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.LoaderUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="armorplus")
public class IntegrationEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDamaged(LivingHurtEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living == null || living.func_130014_f_().field_72995_K) {
            return;
        }
        float normalMit = (float)ModConfig.IntegrationsConfig.normalChaosResistance;
        DamageSource source = event.getSource();
        if (LoaderUtils.isDELoaded()) {
            APArmorMaterial material;
            ItemStack chest = ArmorPlusItemUtils.getChest(living);
            if (chest.func_77973_b() instanceof ItemSpecialArmor && ((material = ((ItemSpecialArmor)chest.func_77973_b()).getMaterial()) == APArmorMaterial.GUARDIAN || material == APArmorMaterial.SUPER_STAR || material == APArmorMaterial.ENDER_DRAGON)) {
                IntegrationEventHandler.mitigateChaos(event, living, normalMit, source);
            }
            if (chest.func_77973_b() instanceof ItemUltimateArmor && DEUtils.isChaosDamage(source) && living instanceof EntityPlayer && ModConfig.IntegrationsConfig.ultimateChaosImmunity) {
                event.setCanceled(true);
            }
        }
    }

    private static void mitigateChaos(LivingHurtEvent event, EntityLivingBase living, float normalMit, DamageSource source) {
        if (DEUtils.isChaosDamage(source)) {
            if (living instanceof EntityPlayer && ((EntityPlayer)living).func_184812_l_()) {
                event.setCanceled(true);
                return;
            }
            event.setAmount(event.getAmount() * (1.0f - normalMit));
            if ((double)event.getAmount() <= 1.0E-4) {
                event.setCanceled(true);
                return;
            }
        }
    }
}

