/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.events;

import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.api.caps.abilities.ISpecialItem;
import com.sofodev.armorplus.common.config.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="armorplus")
public class AbilityDataEventHandler {
    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (AbilityDataEventHandler.isEnabled() && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player == null) {
                return;
            }
            for (ItemStack stack : player.func_184193_aE()) {
                AbilityDataEventHandler.onPlayerJump(event, stack);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                AbilityDataEventHandler.onPlayerJump(event, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPreDamaged(LivingHurtEvent event) {
        if (!AbilityDataEventHandler.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (ItemStack stack : player.func_184193_aE()) {
                AbilityDataEventHandler.onPlayerPreDamaged(event, stack);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                AbilityDataEventHandler.onPlayerPreDamaged(event, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingDamageEvent event) {
        if (AbilityDataEventHandler.isEnabled() && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player == null) {
                return;
            }
            for (ItemStack stack : player.func_184193_aE()) {
                AbilityDataEventHandler.onPlayerDamaged(event, stack);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                AbilityDataEventHandler.onPlayerDamaged(event, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (AbilityDataEventHandler.isEnabled()) {
            EntityPlayer player = event.getPlayer();
            if (player == null) {
                return;
            }
            for (ItemStack stack : player.func_184193_aE()) {
                AbilityDataEventHandler.onPlayerBreakBlock(event, stack);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                AbilityDataEventHandler.onPlayerBreakBlock(event, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKilledEntity(LivingDeathEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        if (AbilityDataEventHandler.isEnabled() && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            for (ItemStack stack : player.func_184193_aE()) {
                AbilityDataEventHandler.onPlayerKilledEntity(event, stack);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                AbilityDataEventHandler.onPlayerKilledEntity(event, stack);
            }
        }
    }

    private static void onPlayerJump(LivingEvent.LivingJumpEvent event, ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler;
        if (AbilityDataEventHandler.isValid(stack) && AbilityDataEventHandler.validateHandler(handler = AbilityDataHandler.getHandler(stack))) {
            handler.getAbilities().stream().filter(data -> AbilityDataEventHandler.canApply(handler, data, stack)).forEach(data -> data.onPlayerJump(stack, event));
        }
    }

    private static void onPlayerPreDamaged(LivingHurtEvent event, ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler;
        if (AbilityDataEventHandler.isValid(stack) && AbilityDataEventHandler.validateHandler(handler = AbilityDataHandler.getHandler(stack))) {
            handler.getAbilities().stream().filter(data -> AbilityDataEventHandler.canApply(handler, data, stack)).forEach(data -> data.onPlayerPreDamaged(stack, event));
        }
    }

    private static void onPlayerDamaged(LivingDamageEvent event, ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler;
        if (AbilityDataEventHandler.isValid(stack) && AbilityDataEventHandler.validateHandler(handler = AbilityDataHandler.getHandler(stack))) {
            handler.getAbilities().stream().filter(data -> AbilityDataEventHandler.canApply(handler, data, stack)).forEach(data -> data.onPlayerDamaged(stack, event));
        }
    }

    private static void onPlayerBreakBlock(BlockEvent.BreakEvent event, ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler;
        if (AbilityDataEventHandler.isValid(stack) && AbilityDataEventHandler.validateHandler(handler = AbilityDataHandler.getHandler(stack))) {
            handler.getAbilities().stream().filter(data -> AbilityDataEventHandler.canApply(handler, data, stack)).forEach(data -> data.onPlayerBreakBlock(stack, event));
        }
    }

    private static void onPlayerKilledEntity(LivingDeathEvent event, ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler;
        if (AbilityDataEventHandler.isValid(stack) && AbilityDataEventHandler.validateHandler(handler = AbilityDataHandler.getHandler(stack))) {
            handler.getAbilities().stream().filter(data -> AbilityDataEventHandler.canApply(handler, data, stack)).forEach(data -> data.onPlayerKillEntity(stack, event));
        }
    }

    private static boolean isEnabled() {
        return ModConfig.Experimental.enableExperimentalMode;
    }

    private static boolean isValid(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ISpecialItem;
    }

    private static boolean validateHandler(AbilityDataHandler.IAbilityHandler handler) {
        return handler != null && AbilityData.hasAbilities(handler);
    }

    private static boolean canApply(AbilityDataHandler.IAbilityHandler handler, AbilityData data, ItemStack stack) {
        return AbilityData.canProvide(stack, data) && AbilityData.contains(handler, data);
    }
}

