/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.Marshallable;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.Marshaller;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import io.netty.buffer.ByteBuf;

public class MarshallableMarshaller<T extends Marshallable>
implements Marshaller<T> {
    private final Class<T> clazz;

    public MarshallableMarshaller(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T unmarshal(ByteBuf in) {
        Marshallable t;
        try {
            t = (Marshallable)this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new BadMessageException("Cannot instanciate marshallable " + this.clazz);
        }
        t.readFromNetwork(in);
        return (T)t;
    }

    @Override
    public void marshal(ByteBuf out, T t) {
        t.writeToNetwork(out);
    }
}

