/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.gui;

import com.elytradev.architecture.common.network.SelectShapeMessage;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.shape.ShapePage;
import com.elytradev.architecture.common.tile.ContainerSawbench;
import com.elytradev.architecture.common.tile.TileSawbench;
import com.elytradev.architecture.legacy.base.BaseGui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiSawbench
extends BaseGui.Screen {
    public static int pageMenuLeft = 176;
    public static int pageMenuTop = 19;
    public static int pageMenuWidth = 58;
    public static int pageMenuRowHeight = 10;
    public static float pageMenuScale = 1.0f;
    public static int shapeMenuLeft = 44;
    public static int shapeMenuTop = 23;
    public static int shapeMenuMargin = 4;
    public static int shapeMenuCellSize = 24;
    public static int shapeMenuRows = 4;
    public static int shapeMenuCols = 5;
    public static int shapeMenuWidth = shapeMenuCols * shapeMenuCellSize;
    public static int shapeMenuHeight = shapeMenuRows * shapeMenuCellSize;
    public static int selectedShapeTitleLeft = 40;
    public static int selectedShapeTitleTop = 128;
    public static int selectedShapeTitleRight = 168;
    public static int materialUsageLeft = 7;
    public static int materialUsageTop = 82;
    public static float shapeMenuScale = 2.0f;
    public static float shapeMenuItemScale = 2.0f;
    public static float shapeMenuItemUSize = 40.0f;
    public static float shapeMenuItemVSize = 45.0f;
    public static float shapeMenuItemWidth = shapeMenuItemUSize / shapeMenuItemScale;
    public static float shapeMenuItemHeight = shapeMenuItemVSize / shapeMenuItemScale;
    TileSawbench te;

    public GuiSawbench(EntityPlayer player, TileSawbench te) {
        super(new ContainerSawbench(player, te));
        this.te = te;
    }

    public static GuiSawbench create(EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSawbench) {
            return new GuiSawbench(player, (TileSawbench)te);
        }
        return null;
    }

    @Override
    protected void drawBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture("gui/gui_sawbench.png", 256, 256);
        this.drawTexturedRect(0.0, 0.0, this.field_146999_f, this.field_147000_g, 0.0, 0.0);
        this.drawShapeMenu();
        this.drawShapeSelection();
        this.drawPageMenu();
        this.drawSelectedShapeTitle();
        this.field_146289_q.func_78276_b("Sawbench", 7, 7, 0x404040);
    }

    void drawPageMenu() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)pageMenuLeft, (float)pageMenuTop, (float)0.0f);
        this.gSave();
        this.setColor(0.4, 0.8, 1.0);
        this.drawRect(0.0, this.te.selectedPage * pageMenuRowHeight, pageMenuWidth, pageMenuRowHeight);
        this.gRestore();
        for (int i = 0; i < TileSawbench.pages.length; ++i) {
            this.drawString(TileSawbench.pages[i].title, 1, 1);
            GL11.glTranslatef((float)0.0f, (float)pageMenuRowHeight, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    void drawShapeMenu() {
        ShapePage page;
        this.gSave();
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)shapeMenuLeft, (float)shapeMenuTop, (float)0.0f);
        this.bindTexture("gui/shapemenu_bg.png", 256, 256);
        double w = shapeMenuWidth + 2 * shapeMenuMargin;
        double h = shapeMenuHeight + 2 * shapeMenuMargin;
        this.drawTexturedRect(-shapeMenuMargin, -shapeMenuMargin, w, h, 0.0, 0.0, (double)shapeMenuScale * w, (double)shapeMenuScale * h);
        this.bindTexture("gui/shapemenu_items.png", 512, 512);
        int p = this.te.selectedPage;
        if (p >= 0 && p < TileSawbench.pages.length && (page = TileSawbench.pages[p]) != null) {
            Shape[] shapes = page.shapes;
            for (int i = 0; i < shapes.length; ++i) {
                Shape shape = shapes[i];
                int mrow = i / shapeMenuCols;
                int mcol = i % shapeMenuCols;
                int id = shape.id;
                int trow = id / 10;
                int tcol = id % 10;
                this.drawTexturedRect(((double)mcol + 0.5) * (double)shapeMenuCellSize - 0.5 * (double)shapeMenuItemWidth, ((double)mrow + 0.5) * (double)shapeMenuCellSize - 0.5 * (double)shapeMenuItemHeight, shapeMenuItemWidth, shapeMenuItemHeight, (float)tcol * shapeMenuItemUSize, (float)trow * shapeMenuItemVSize, shapeMenuItemUSize, shapeMenuItemVSize);
            }
        }
        GL11.glPopMatrix();
        this.gRestore();
    }

    void drawShapeSelection() {
        int i = this.te.selectedSlots[this.te.selectedPage];
        int row = i / shapeMenuCols;
        int col = i % shapeMenuCols;
        int x = shapeMenuLeft + shapeMenuCellSize * col;
        int y = shapeMenuTop + shapeMenuCellSize * row;
        this.drawTexturedRect(x, y, 24.5, 24.5, 44.0, 23.0, 49.0, 49.0);
    }

    void drawSelectedShapeTitle() {
        Shape shape = this.te.getSelectedShape();
        if (shape != null) {
            int x = selectedShapeTitleLeft;
            int w = this.field_146289_q.func_78256_a(shape.title);
            if (x + w > selectedShapeTitleRight) {
                x = selectedShapeTitleRight - w;
            }
            this.drawString(shape.title, x, selectedShapeTitleTop);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)materialUsageLeft, (float)materialUsageTop, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.drawString(String.format("%s makes %s", this.te.materialMultiple(), this.te.resultMultiple()), 0, 0);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void mousePressed(int x, int y, int btn) {
        if (x >= pageMenuLeft && y >= pageMenuTop && x < pageMenuLeft + pageMenuWidth) {
            this.clickPageMenu(x - pageMenuLeft, y - pageMenuTop);
        } else if (x >= shapeMenuLeft && y >= shapeMenuTop && x < shapeMenuLeft + shapeMenuWidth && y < shapeMenuTop + shapeMenuHeight) {
            this.clickShapeMenu(x - shapeMenuLeft, y - shapeMenuTop);
        } else {
            super.mousePressed(x, y, btn);
        }
    }

    void clickPageMenu(int x, int y) {
        int i = y / pageMenuRowHeight;
        if (i >= 0 && i < TileSawbench.pages.length) {
            this.sendSelectShape(i, this.te.selectedSlots[i]);
        }
    }

    void clickShapeMenu(int x, int y) {
        int row = y / shapeMenuCellSize;
        int col = x / shapeMenuCellSize;
        if (row >= 0 && row < shapeMenuRows && col >= 0 && col < shapeMenuCols) {
            int i = row * shapeMenuCols + col;
            this.sendSelectShape(this.te.selectedPage, i);
        }
    }

    protected void sendSelectShape(int page, int slot) {
        new SelectShapeMessage(this.te, page, slot).sendToServer();
    }
}

