/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.OreDictFilterMatcher;
import appeng.util.item.OreReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreHelper {
    public static final OreHelper INSTANCE = new OreHelper();
    private final LoadingCache<String, List<ItemStack>> oreDictCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ItemStack>>(){

        public List<ItemStack> load(String oreName) {
            return OreDictionary.getOres((String)oreName);
        }
    });
    private final Map<ItemRef, OreReference> references = new HashMap<ItemRef, OreReference>();

    public Optional<OreReference> getOre(ItemStack itemStack) {
        ItemRef ir = new ItemRef(itemStack);
        if (!this.references.containsKey(ir)) {
            OreReference ref = new OreReference();
            Collection<Integer> ores = ref.getOres();
            Collection<String> set = ref.getEquivalents();
            HashSet<String> toAdd = new HashSet<String>();
            block0: for (String ore : OreDictionary.getOreNames()) {
                if (ore == null || toAdd.contains(ore)) continue;
                for (ItemStack oreItem : (List)this.oreDictCache.getUnchecked((Object)ore)) {
                    if (!OreDictionary.itemMatches((ItemStack)oreItem, (ItemStack)itemStack, (boolean)false)) continue;
                    toAdd.add(ore);
                    continue block0;
                }
            }
            for (String ore : toAdd) {
                set.add(ore);
                ores.add(OreDictionary.getOreID((String)ore));
            }
            if (!set.isEmpty()) {
                this.references.put(ir, ref);
            } else {
                this.references.put(ir, null);
            }
        }
        return Optional.ofNullable(this.references.get(ir));
    }

    boolean sameOre(AEItemStack aeItemStack, IAEItemStack is) {
        OreReference a = aeItemStack.getOre().orElse(null);
        OreReference b = ((AEItemStack)is).getOre().orElse(null);
        return this.sameOre(a, b);
    }

    public boolean sameOre(OreReference a, OreReference b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        Collection<Integer> bOres = b.getOres();
        for (Integer ore : a.getOres()) {
            if (!bOres.contains(ore)) continue;
            return true;
        }
        return false;
    }

    boolean sameOre(AEItemStack aeItemStack, ItemStack o) {
        return aeItemStack.getOre().map(a -> {
            for (String oreName : a.getEquivalents()) {
                for (ItemStack oreItem : (List)this.oreDictCache.getUnchecked((Object)oreName)) {
                    if (!OreDictionary.itemMatches((ItemStack)oreItem, (ItemStack)o, (boolean)false)) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    public Set<Integer> getMatchingOre(String oreExp) {
        HashSet<Integer> matchingIds = new HashSet<Integer>();
        List<OreDictFilterMatcher.MatchRule> rulesList = OreDictFilterMatcher.parseExpression(oreExp);
        for (String ore : OreDictionary.getOreNames()) {
            if (!OreDictFilterMatcher.matches(rulesList, ore)) continue;
            matchingIds.add(OreDictionary.getOreID((String)ore));
        }
        return matchingIds;
    }

    public List<ItemStack> getCachedOres(String oreName) {
        return (List)this.oreDictCache.getUnchecked((Object)oreName);
    }

    private static class ItemRef {
        private final Item ref;
        private final int damage;
        private final int hash;

        ItemRef(ItemStack stack) {
            this.ref = stack.func_77973_b();
            this.damage = stack.func_77973_b().func_77645_m() ? 0 : stack.func_77952_i();
            this.hash = this.ref.hashCode() ^ this.damage;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemRef other = (ItemRef)obj;
            return this.damage == other.damage && this.ref == other.ref;
        }

        public String toString() {
            return "ItemRef [ref=" + this.ref.func_77658_a() + ", damage=" + this.damage + ", hash=" + this.hash + ']';
        }
    }
}

