/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mezz.jei.api.gui.ITooltipCallback;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.lwjgl.input.Mouse;

public class CraftableCallBack
implements ITooltipCallback<ItemStack> {
    private final IItemList<IAEItemStack> list;
    private final Container container;
    private final Stopwatch lastClicked = Stopwatch.createStarted();

    public CraftableCallBack(Container container, IItemList<IAEItemStack> ir) {
        this.list = ir;
        this.container = container;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (!input) {
            return;
        }
        if (this.list != null) {
            IItemList<IAEItemStack> available = this.mergeInventories(this.list, (ContainerCraftingTerm)this.container);
            AEItemStack search = AEItemStack.fromItemStack(ingredient);
            if (ingredient.func_77973_b().func_77645_m() || Platform.isGTDamageableItem(ingredient.func_77973_b())) {
                Collection<IAEItemStack> fuzzy = available.findFuzzy(search, FuzzyMode.IGNORE_ALL);
                if (fuzzy.size() > 0) {
                    for (IAEItemStack itemStack : fuzzy) {
                        if (itemStack.getStackSize() > 0L) {
                            if (Platform.isGTDamageableItem(ingredient.func_77973_b()) && ingredient.func_77960_j() != itemStack.getDefinition().func_77960_j()) {
                                continue;
                            }
                            break;
                        }
                        String line = "\u00a7c[" + I18n.func_74837_a((String)"gui.appliedenergistics2.Missing", (Object[])new Object[0]) + "]";
                        tooltip.add(line);
                        if (!itemStack.isCraftable()) continue;
                        line = "\u00a71[" + I18n.func_74837_a((String)"gui.tooltips.appliedenergistics2.Craftable", (Object[])new Object[0]) + "]";
                        tooltip.add(line);
                        if (!Mouse.isButtonDown((int)2) || this.lastClicked.elapsed(TimeUnit.MILLISECONDS) <= 200L) continue;
                        this.lastClicked.reset().start();
                        ((AEBaseContainer)this.container).setTargetStack(itemStack);
                        PacketInventoryAction p = new PacketInventoryAction(InventoryAction.AUTO_CRAFT, this.container.func_75138_a().size(), 0L);
                        NetworkHandler.instance().sendToServer(p);
                    }
                } else {
                    String line = "\u00a7c[" + I18n.func_74837_a((String)"gui.appliedenergistics2.Missing", (Object[])new Object[0]) + "]";
                    tooltip.add(line);
                }
            } else {
                IAEItemStack found = available.findPrecise(search);
                if (found != null) {
                    String line;
                    if (found.getStackSize() == 0L) {
                        line = "\u00a7c[" + I18n.func_74837_a((String)"gui.appliedenergistics2.Missing", (Object[])new Object[0]) + "]";
                        tooltip.add(line);
                    }
                    if (found.isCraftable()) {
                        line = "\u00a71[" + I18n.func_74837_a((String)"gui.tooltips.appliedenergistics2.Craftable", (Object[])new Object[0]) + "]";
                        tooltip.add(line);
                        if (Mouse.isButtonDown((int)2) && this.lastClicked.elapsed(TimeUnit.MILLISECONDS) > 200L) {
                            this.lastClicked.reset().start();
                            ((AEBaseContainer)this.container).setTargetStack(found);
                            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.AUTO_CRAFT, this.container.func_75138_a().size(), 0L);
                            NetworkHandler.instance().sendToServer(p);
                        }
                    }
                } else {
                    String line = "\u00a7c[" + I18n.func_74837_a((String)"gui.appliedenergistics2.Missing", (Object[])new Object[0]) + "]";
                    tooltip.add(line);
                }
            }
        }
    }

    IItemList<IAEItemStack> mergeInventories(IItemList<IAEItemStack> repo, ContainerCraftingTerm containerCraftingTerm) {
        IItemList<IAEItemStack> itemList = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        for (IAEItemStack i : repo) {
            itemList.addStorage(i);
        }
        PlayerMainInvWrapper invWrapper = new PlayerMainInvWrapper(containerCraftingTerm.getPlayerInv());
        for (int i = 0; i < invWrapper.getSlots(); ++i) {
            itemList.addStorage(AEItemStack.fromItemStack(invWrapper.getStackInSlot(i)));
        }
        IItemHandler itemHandler = containerCraftingTerm.getInventoryByName("crafting");
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            itemList.addStorage(AEItemStack.fromItemStack(itemHandler.getStackInSlot(i)));
        }
        return itemList;
    }
}

