/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.container.AEBaseContainer;
import appeng.util.helpers.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class AppEngSlot
extends Slot {
    private static final IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    private final IItemHandler itemHandler;
    private final int index;
    private final int defX;
    private final int defY;
    private boolean isDraggable = true;
    private boolean isPlayerSide = false;
    private AEBaseContainer myContainer = null;
    private int IIcon = -1;
    private hasCalculatedValidness isValid;
    private boolean isDisplay = false;
    private boolean returnAsSingleStack;

    public AppEngSlot(IItemHandler inv, int idx, int x, int y) {
        super(emptyInventory, idx, x, y);
        this.itemHandler = inv;
        this.index = idx;
        this.defX = x;
        this.defY = y;
        this.setIsValid(hasCalculatedValidness.NotAvailable);
    }

    public Slot setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public Slot setPlayerSide() {
        this.isPlayerSide = true;
        return this;
    }

    public String getTooltip() {
        return null;
    }

    public void clearStack() {
        ItemHandlerUtil.setStackInSlot(this.itemHandler, this.index, ItemStack.field_190927_a);
    }

    public boolean func_75214_a(@Nonnull ItemStack par1ItemStack) {
        if (this.isSlotEnabled()) {
            return this.itemHandler.isItemValid(this.index, par1ItemStack);
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        if (!this.isSlotEnabled()) {
            return ItemStack.field_190927_a;
        }
        if (this.itemHandler.getSlots() <= this.getSlotIndex()) {
            return ItemStack.field_190927_a;
        }
        if (this.isDisplay()) {
            this.setDisplay(false);
            if (this.returnAsSingleStack()) {
                this.setReturnAsSingleStack(false);
                ItemStack ret = this.getDisplayStack().func_77946_l();
                ret.func_190920_e(1);
                return ret;
            }
            return this.getDisplayStack();
        }
        return this.itemHandler.getStackInSlot(this.index);
    }

    private boolean returnAsSingleStack() {
        return this.returnAsSingleStack;
    }

    public void setReturnAsSingleStack(boolean returnAsSingleStack) {
        this.returnAsSingleStack = returnAsSingleStack;
    }

    public void func_75215_d(ItemStack stack) {
        if (this.isSlotEnabled()) {
            ItemHandlerUtil.setStackInSlot(this.itemHandler, this.index, stack);
            if (this.getContainer() != null) {
                this.getContainer().onSlotChange(this);
            }
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void func_75218_e() {
        this.setIsValid(hasCalculatedValidness.NotAvailable);
        if (this.isSlotEnabled() && this.itemHandler != null) {
            ItemHandlerUtil.setStackInSlot(this.itemHandler, this.index, this.func_75211_c().func_77946_l());
            if (this.getContainer() != null) {
                this.getContainer().onSlotChange(this);
            }
        }
        super.func_75218_e();
    }

    public int func_75219_a() {
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return Math.min(this.func_75219_a(), stack.func_77976_d());
    }

    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        if (this.isSlotEnabled()) {
            return !this.itemHandler.extractItem(this.index, Integer.MAX_VALUE, true).func_190926_b();
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.itemHandler.extractItem(this.index, amount, false);
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof AppEngSlot && ((AppEngSlot)other).itemHandler == this.itemHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_111238_b() {
        return this.isSlotEnabled();
    }

    public boolean isSlotEnabled() {
        return true;
    }

    public ItemStack getDisplayStack() {
        return this.itemHandler.getStackInSlot(this.index);
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public int getIcon() {
        return this.getIIcon();
    }

    public boolean isPlayerSide() {
        return this.isPlayerSide;
    }

    public boolean shouldDisplay() {
        return this.isSlotEnabled();
    }

    public int getX() {
        return this.defX;
    }

    public int getY() {
        return this.defY;
    }

    private int getIIcon() {
        return this.IIcon;
    }

    public void setIIcon(int iIcon) {
        this.IIcon = iIcon;
    }

    private boolean isDisplay() {
        return this.isDisplay;
    }

    public void setDisplay(boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    void setPlayerSide(boolean isPlayerSide) {
        this.isPlayerSide = isPlayerSide;
    }

    public hasCalculatedValidness getIsValid() {
        return this.isValid;
    }

    public void setIsValid(hasCalculatedValidness isValid) {
        this.isValid = isValid;
    }

    protected AEBaseContainer getContainer() {
        return this.myContainer;
    }

    public void setContainer(AEBaseContainer myContainer) {
        this.myContainer = myContainer;
    }

    public static enum hasCalculatedValidness {
        NotAvailable,
        Valid,
        Invalid;

    }
}

