/*
 * Decompiled with CFR 0.152.
 */
package shadows.toaster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.toaster.BetterGuiToast;

@Mod(modid="toastcontrol", version="1.8.1", name="Toast Control", clientSideOnly=true, dependencies="required-after:placebo@[1.6,)", acceptedMinecraftVersions="[1.12.2]")
public class ToastControl {
    public static final String MODID = "toastcontrol";
    public static final String MODNAME = "Toast Control";
    public static final String VERSION = "1.8.1";
    public static final String DEPS = "required-after:placebo@[1.6,)";
    public static final Logger LOGGER = LogManager.getLogger((String)"toastcontrol");
    public static final KeyBinding CLEAR = new KeyBinding("key.toastcontrol.clear", 36, "key.toastcontrol.category");
    public static final ResourceLocation TRANSLUCENT = new ResourceLocation("toastcontrol", "textures/gui/toasts.png");
    public static final ResourceLocation TRANSPARENT = new ResourceLocation("toastcontrol", "textures/gui/toasts2.png");
    public static final ResourceLocation ORIGINAL = new ResourceLocation("textures/gui/toasts.png");
    public static final List<Class<?>> BLOCKED_CLASSES = new ArrayList();
    public static List<BetterGuiToast.BetterToastInstance<?>> tracker = new ArrayList();

    @SubscribeEvent
    public void keys(InputEvent.KeyInputEvent e) {
        if (CLEAR.func_151470_d() && CLEAR.func_151468_f()) {
            Minecraft.func_71410_x().func_193033_an().func_191788_b();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        Minecraft.func_71410_x().field_193034_aS = new BetterGuiToast();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ToastControl.handleToastReloc();
        ToastControl.handleBlockedClasses();
        ClientRegistry.registerKeyBinding((KeyBinding)CLEAR);
    }

    private static void handleToastReloc() {
        ResourceLocation target = IToast.field_193654_a;
        if (ToastControlConfig.translucent) {
            ToastControl.change(target, TRANSLUCENT);
        }
        if (ToastControlConfig.transparent) {
            ToastControl.change(target, TRANSPARENT);
        } else if (!ToastControlConfig.translucent && !ToastControlConfig.transparent) {
            ToastControl.change(target, ORIGINAL);
        }
    }

    private static void change(ResourceLocation a, ResourceLocation b) {
        ReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.func_110624_b(), (String)"namespace", (String)"field_110626_a");
        ReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.func_110623_a(), (String)"path", (String)"field_110625_b");
    }

    private static void handleBlockedClasses() {
        BLOCKED_CLASSES.clear();
        for (String s : ToastControlConfig.blockedClasses) {
            try {
                Class<?> c = Class.forName(s);
                BLOCKED_CLASSES.add(c);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Invalid class string provided to toast control: " + s);
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        for (BetterGuiToast.BetterToastInstance<?> t : tracker) {
            t.tick();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            ToastControl.handleToastReloc();
            ToastControl.handleBlockedClasses();
            ((BetterGuiToast)Minecraft.func_71410_x().field_193034_aS).field_191791_g = new GuiToast.ToastInstance[ToastControlConfig.toastCount];
            LOGGER.info("Toast control config reloaded.");
        }
    }

    @Config(modid="toastcontrol", category="Toast Types")
    public static class ToastControlConfig {
        @Config.Name(value="Disable Advancements")
        @Config.Comment(value={"If advancement toasts are blocked. Enabling will block ALL advancements."})
        public static boolean advancements = true;
        @Config.Name(value="Disable Recipes")
        @Config.Comment(value={"If recipe unlock toasts are blocked. Blocks \"you have unlocked a new recipe\" toasts."})
        public static boolean recipes = true;
        @Config.Name(value="Disable System Toasts")
        @Config.Comment(value={"If system toasts are blocked. This is used only for the narrator toggle notification right now."})
        public static boolean system = false;
        @Config.Name(value="Disable Tutorials")
        @Config.Comment(value={"If tutorial toasts are blocked. Blocks useless things like use WASD to move."})
        public static boolean tutorial = true;
        @Config.Name(value="Disable All Vanilla")
        @Config.Comment(value={"If all vanilla toasts are blocked.  Includes advancements, recipes, system, and tutorials."})
        public static boolean globalVanilla = false;
        @Config.Name(value="Disable All Non-Vanilla")
        @Config.Comment(value={"If all non-vanilla toasts are blocked.  Blocks all toasts that do not extend vanilla classes."})
        public static boolean globalModded = false;
        @Config.Name(value="Disable All")
        @Config.Comment(value={"If all toasts are blocked."})
        public static boolean global = false;
        @Config.Name(value="Forced Display Time")
        @Config.Comment(value={"How long (in ticks) to force a toast to show for.  Higher is longer."})
        public static int forceTime = 0;
        @Config.Name(value="Translucent Toasts")
        @Config.Comment(value={"If toasts are slightly translucent."})
        public static boolean translucent = true;
        @Config.Name(value="Transparent Toasts")
        @Config.Comment(value={"If toasts do not draw a background."})
        public static boolean transparent = false;
        @Config.Name(value="Max Toasts Shown")
        @Config.Comment(value={"The maximum number of toasts on the screen at once.  Default 3, Vanilla uses 5."})
        @Config.RangeInt(min=1, max=7)
        public static int toastCount = 3;
        @Config.Name(value="Print Toast Classnames")
        @Config.Comment(value={"A debug config to print the class of each toast that tries to enter the GUI.  Useful for finding classes to block."})
        public static boolean printClasses = false;
        @Config.Name(value="Blacklisted Classes")
        @Config.Comment(value={"A Class-specific blacklist for toasts.  Insert class names."})
        public static String[] blockedClasses = new String[0];
        @Config.Name(value="Toast X Offset")
        @Config.Comment(value={"The amount to offset a toast in the x axis."})
        public static int offsetX = 0;
        @Config.Name(value="Toast Y Offset")
        @Config.Comment(value={"The amount to offset a toast in the y axis."})
        public static int offsetY = 0;
        @Config.Name(value="Disable Transitions")
        @Config.Comment(value={"Set to true to disable toasts sliding in to view."})
        public static boolean noSlide = false;
        @Config.Name(value="Transition from Left")
        @Config.Comment(value={"Set to true to change the transition to start from the left."})
        public static boolean startLeft = false;
    }
}

