/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class GourmandManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 2000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return 0;
        }
        int energy = fuelMap.get((Object)new ComparableItemStack(stack));
        if (energy > 0) {
            return energy;
        }
        if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            int foodEnergy = food.func_150905_g(stack) * DEFAULT_ENERGY;
            int satEnergy = (int)(food.func_150906_h(stack) * (float)foodEnergy * 2.0f);
            return foodEnergy + satEnergy;
        }
        return 0;
    }

    public static int getPaleoFuelEnergy(ItemStack stack) {
        return GourmandManager.getFuelEnergy(stack);
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 2000 || energy > 200000000) {
            return false;
        }
        if (fuelMap.containsKey((Object)new ComparableItemStack(stack))) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

