/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnerBuilder {
    public static final String SPAWN_DELAY = "Delay";
    public static final String SPAWN_POTENTIALS = "SpawnPotentials";
    public static final String SPAWN_DATA = "SpawnData";
    public static final String MIN_SPAWN_DELAY = "MinSpawnDelay";
    public static final String MAX_SPAWN_DELAY = "MaxSpawnDelay";
    public static final String SPAWN_COUNT = "SpawnCount";
    public static final String MAX_NEARBY_ENTITIES = "MaxNearbyEntities";
    public static final String REQUIRED_PLAYER_RANGE = "RequiredPlayerRange";
    public static final String SPAWN_RANGE = "SpawnRange";
    public static final String ID = "id";
    public static final String ENTITY = "Entity";
    public static final NBTTagCompound BASE_TAG;
    NBTTagCompound tag = BASE_TAG.func_74737_b();
    boolean hasPotentials = false;
    WeightedSpawnerEntity baseEntity = new WeightedSpawnerEntity();

    public SpawnerBuilder() {
        this.tag.func_74782_a(SPAWN_DATA, (NBTBase)this.baseEntity.func_185277_b());
    }

    public SpawnerBuilder setType(Class<? extends Entity> entity) {
        return this.setType(EntityList.func_191306_a(entity));
    }

    public SpawnerBuilder setType(ResourceLocation entity) {
        this.baseEntity.func_185277_b().func_74778_a(ID, entity.toString());
        return this;
    }

    public SpawnerBuilder setDelay(int delay) {
        this.tag.func_74777_a(SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMinDelay(int delay) {
        this.tag.func_74777_a(MIN_SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMaxDelay(int delay) {
        this.tag.func_74777_a(MAX_SPAWN_DELAY, (short)delay);
        return this;
    }

    public SpawnerBuilder setMinAndMaxDelay(int min, int max) {
        this.setMinDelay(min);
        this.setMaxDelay(max);
        return this;
    }

    public SpawnerBuilder setSpawnCount(int count) {
        this.tag.func_74777_a(SPAWN_COUNT, (short)count);
        return this;
    }

    public SpawnerBuilder setMaxNearbyEntities(int max) {
        this.tag.func_74777_a(MAX_NEARBY_ENTITIES, (short)max);
        return this;
    }

    public SpawnerBuilder setPlayerRange(int range) {
        this.tag.func_74777_a(REQUIRED_PLAYER_RANGE, (short)range);
        return this;
    }

    public SpawnerBuilder setSpawnRange(int range) {
        this.tag.func_74777_a(SPAWN_RANGE, (short)range);
        return this;
    }

    public SpawnerBuilder setSpawnData(NBTTagCompound data) {
        if (data == null) {
            data = new NBTTagCompound();
            data.func_74778_a(ID, "minecraft:pig");
        }
        this.baseEntity.field_185279_b = data.func_74737_b();
        return this;
    }

    public SpawnerBuilder setPotentials(WeightedSpawnerEntity ... entries) {
        this.hasPotentials = true;
        this.tag.func_74782_a(SPAWN_POTENTIALS, (NBTBase)new NBTTagList());
        NBTTagList list = this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
        for (WeightedSpawnerEntity e : entries) {
            list.func_74742_a((NBTBase)e.func_185278_a());
        }
        return this;
    }

    public SpawnerBuilder addPotentials(WeightedSpawnerEntity ... entries) {
        this.hasPotentials = true;
        NBTTagList list = this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
        for (WeightedSpawnerEntity e : entries) {
            list.func_74742_a((NBTBase)e.func_185278_a());
        }
        return this;
    }

    public NBTTagCompound getSpawnData() {
        return this.tag.func_74775_l(SPAWN_DATA);
    }

    public NBTTagList getPotentials() {
        return this.tag.func_150295_c(SPAWN_POTENTIALS, 10);
    }

    public TileEntityMobSpawner build(World world, BlockPos pos) {
        TileEntityMobSpawner s = (TileEntityMobSpawner)((ITileEntityProvider)Blocks.field_150474_ac).func_149915_a(null, 0);
        if (!this.hasPotentials) {
            NBTTagList list = new NBTTagList();
            list.func_74742_a((NBTBase)this.baseEntity.func_185278_a());
            this.tag.func_74782_a(SPAWN_POTENTIALS, (NBTBase)list);
        }
        s.func_145834_a(world);
        s.func_174878_a(pos);
        s.func_145839_a(this.tag);
        return s;
    }

    static {
        TileEntityMobSpawner te = (TileEntityMobSpawner)((ITileEntityProvider)Blocks.field_150474_ac).func_149915_a(null, 0);
        te.func_145881_a().func_190894_a(new ResourceLocation("minecraft:pig"));
        BASE_TAG = te.func_189515_b(new NBTTagCompound());
    }
}

