/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiUnpackager;
import thelm.packagedauto.container.ContainerUnpackager;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileUnpackager;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternHelper;
import thelm.packagedauto.inventory.InventoryUnpackager;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingProvider", modid="appliedenergistics2")})
public class TileUnpackager
extends TileBase
implements ITickable,
IGridHost,
IActionHost,
ICraftingProvider {
    public static int energyCapacity = 5000;
    public static int energyUsage = 50;
    public static boolean drawMEEnergy = true;
    public final PackageTracker[] trackers = new PackageTracker[10];
    public List<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();
    public boolean powered = false;
    public boolean blocking = false;
    public HostHelperTileUnpackager hostHelper;

    public TileUnpackager() {
        this.setInventory(new InventoryUnpackager(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new PackageTracker();
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileUnpackager(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.unpackager.name");
    }

    public void onLoad() {
        this.updatePowered();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                this.fillTrackers();
                this.emptyTrackers();
                if (drawMEEnergy && this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.chargeEnergy();
                }
            }
            this.energyStorage.updateIfChanged();
        }
    }

    protected void fillTrackers() {
        List emptyTrackers = Arrays.stream(this.trackers).filter(t -> t.isEmpty()).collect(Collectors.toList());
        List nonEmptyTrackers = Arrays.stream(this.trackers).filter(t -> !t.isEmpty()).filter(t -> !t.isFilled()).collect(Collectors.toList());
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.energyStorage.getEnergyStored() < energyUsage || (stack = this.inventory.func_70301_a(i)).func_190926_b() || !(stack.func_77973_b() instanceof IPackageItem)) continue;
            IPackageItem packageItem = (IPackageItem)stack.func_77973_b();
            boolean flag = false;
            for (PackageTracker tracker : nonEmptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    flag = true;
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    break;
                }
                tracker.setRejectedIndex(i, true);
            }
            if (flag) continue;
            for (PackageTracker tracker : emptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    continue block0;
                }
                tracker.setRejectedIndex(i, true);
            }
        }
    }

    protected void emptyTrackers() {
        TileEntity tile;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(tile instanceof IPackageCraftingMachine)) continue;
            IPackageCraftingMachine machine = (IPackageCraftingMachine)tile;
            for (PackageTracker tracker : this.trackers) {
                if (!tracker.isFilled() || tracker.recipe == null || !tracker.recipe.getRecipeType().hasMachine() || machine.isBusy() || !machine.acceptPackage(tracker.recipe, Lists.transform(tracker.recipe.getInputs(), ItemStack::func_77946_l), facing.func_176734_d())) continue;
                tracker.clearRecipe();
                this.syncTile(false);
                this.func_70296_d();
                continue block0;
            }
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            PackageTracker trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.facing == facing).findFirst().orElse(null);
            if (trackerToEmpty == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            if (trackerToEmpty.recipe != null && trackerToEmpty.recipe.getRecipeType().hasMachine()) {
                trackerToEmpty.facing = null;
                continue;
            }
            if (tile == null || tile instanceof TilePackager || tile instanceof TileUnpackager || this.isInterface(tile, facing.func_176734_d()) || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                trackerToEmpty.facing = null;
                continue;
            }
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                ItemStack stack = trackerToEmpty.toSend.get(i);
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack stackRem = itemHandler.insertItem(slot, stack, false);
                    if (stackRem.func_190916_E() < stack.func_190916_E()) {
                        stack = stackRem;
                    }
                    if (stack.func_190926_b()) break;
                }
                trackerToEmpty.toSend.set(i, stack);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.func_70296_d();
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            PackageTracker trackerToEmpty;
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TilePackager || tile instanceof TileUnpackager || this.isInterface(tile, facing.func_176734_d()) || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            if (this.powered || this.blocking && !MiscUtil.isEmpty(itemHandler) || (trackerToEmpty = (PackageTracker)Arrays.stream(this.trackers).filter(t -> t.isFilled()).filter(t -> t.facing == null).findFirst().orElse(null)) == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            if (trackerToEmpty.recipe != null && trackerToEmpty.recipe.getRecipeType().hasMachine()) continue;
            boolean inserted = false;
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                ItemStack stack = trackerToEmpty.toSend.get(i);
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack stackRem = itemHandler.insertItem(slot, stack, false);
                    if (stackRem.func_190916_E() < stack.func_190916_E()) {
                        stack = stackRem;
                        inserted = true;
                    }
                    if (stack.func_190926_b()) break;
                }
                trackerToEmpty.toSend.set(i, stack);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
            if (!inserted) continue;
            trackerToEmpty.facing = facing;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.func_70296_d();
        }
    }

    protected void chargeEnergy() {
        int prevStored = this.energyStorage.getEnergyStored();
        ItemStack energyStack = this.inventory.func_70301_a(10);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(10, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void setPlacer(EntityPlayer placer) {
        this.placerID = AEApi.instance().registries().players().getID(placer);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isBusy() && patternDetails instanceof RecipeCraftingPatternHelper) {
            int i;
            IntArrayList emptySlots = new IntArrayList();
            for (int i2 = 0; i2 < 9; ++i2) {
                if (!this.inventory.func_70301_a(i2).func_190926_b()) continue;
                emptySlots.add(i2);
            }
            IntArrayList requiredSlots = new IntArrayList();
            for (i = 0; i < table.func_70302_i_(); ++i) {
                if (table.func_70301_a(i).func_190926_b()) continue;
                requiredSlots.add(i);
            }
            if (requiredSlots.size() > emptySlots.size()) {
                return false;
            }
            for (i = 0; i < requiredSlots.size(); ++i) {
                this.inventory.func_70299_a(emptySlots.getInt(i), table.func_70301_a(requiredSlots.getInt(i)).func_77946_l());
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isBusy() {
        return Arrays.stream(this.trackers).noneMatch(PackageTracker::isEmpty);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        ItemStack patternStack = this.inventory.func_70301_a(9);
        for (IRecipeInfo pattern : this.recipeList) {
            if (pattern.getOutputs().isEmpty()) continue;
            craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new RecipeCraftingPatternHelper(patternStack, pattern));
        }
    }

    protected boolean isInterface(TileEntity tile, EnumFacing facing) {
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            return AppEngUtil.isInterface(tile, facing);
        }
        return false;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.blocking = nbt.func_74767_n("Blocking");
        this.powered = nbt.func_74767_n("Powered");
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i].readFromNBT(nbt.func_74775_l(String.format("Tracker%02d", i)));
        }
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74757_a("Powered", this.powered);
        for (int i = 0; i < this.trackers.length; ++i) {
            NBTTagCompound subNBT = new NBTTagCompound();
            this.trackers[i].writeToNBT(subNBT);
            nbt.func_74782_a(String.format("Tracker%02d", i), (NBTBase)subNBT);
        }
        return nbt;
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiUnpackager(new ContainerUnpackager(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerUnpackager(player.field_71071_by, this);
    }

    public class PackageTracker {
        public boolean[] rejectedIndexes = new boolean[9];
        public IRecipeInfo recipe;
        public int amount;
        public BooleanList received = new BooleanArrayList();
        public List<ItemStack> toSend = new ArrayList<ItemStack>();
        public EnumFacing facing;

        public void setRecipe(IRecipeInfo recipe) {
            this.recipe = recipe;
        }

        public void clearRecipe() {
            this.clearRejectedIndexes();
            this.recipe = null;
            this.amount = 0;
            this.received.clear();
            this.facing = null;
            if (TileUnpackager.this.field_145850_b != null && !((TileUnpackager)TileUnpackager.this).field_145850_b.field_72995_K) {
                TileUnpackager.this.syncTile(false);
                TileUnpackager.this.func_70296_d();
            }
        }

        public boolean tryAcceptPackage(IPackageItem packageItem, ItemStack stack, int invIndex) {
            if (this.rejectedIndexes[invIndex]) {
                return false;
            }
            IRecipeInfo recipe = packageItem.getRecipeInfo(stack);
            if (recipe != null) {
                int index;
                if (this.recipe == null) {
                    this.recipe = recipe;
                    this.amount = recipe.getPatterns().size();
                    this.received.size(this.amount);
                    this.received.set(packageItem.getIndex(stack), true);
                    TileUnpackager.this.syncTile(false);
                    TileUnpackager.this.func_70296_d();
                    return true;
                }
                if (this.recipe.equals(recipe) && !((Boolean)this.received.get(index = packageItem.getIndex(stack))).booleanValue()) {
                    this.received.set(index, true);
                    TileUnpackager.this.syncTile(false);
                    TileUnpackager.this.func_70296_d();
                    return true;
                }
            }
            return false;
        }

        public void setRejectedIndex(int index, boolean rejected) {
            this.rejectedIndexes[index] = rejected;
        }

        public void clearRejectedIndexes() {
            Arrays.fill(this.rejectedIndexes, false);
        }

        public boolean isFilled() {
            if (!this.toSend.isEmpty()) {
                return true;
            }
            if (this.received.isEmpty()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.received.iterator();
            while (booleanListIterator.hasNext()) {
                boolean b = (Boolean)booleanListIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.recipe == null || !this.recipe.isValid();
        }

        public void setupToSend() {
            if (this.isEmpty() || this.recipe.getRecipeType().hasMachine() || !this.toSend.isEmpty()) {
                return;
            }
            this.toSend.addAll(Lists.transform(this.recipe.getInputs(), ItemStack::func_77946_l));
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.clearRecipe();
            NBTTagCompound tag = nbt.func_74775_l("Recipe");
            IRecipeInfo recipe = MiscUtil.readRecipeFromNBT(tag);
            if (recipe != null) {
                this.recipe = recipe;
                this.amount = nbt.func_74771_c("Amount");
                this.received.size(this.amount);
                byte[] receivedArray = nbt.func_74770_j("Received");
                for (int i = 0; i < this.received.size(); ++i) {
                    this.received.set(i, receivedArray[i] != 0);
                }
            }
            MiscUtil.loadAllItems(nbt.func_150295_c("ToSend", 10), this.toSend);
            if (nbt.func_74764_b("Facing")) {
                this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("Facing"));
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.recipe != null) {
                NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), this.recipe);
                nbt.func_74782_a("Recipe", (NBTBase)tag);
                nbt.func_74774_a("Amount", (byte)this.amount);
                byte[] receivedArray = new byte[this.received.size()];
                for (int i = 0; i < this.received.size(); ++i) {
                    receivedArray[i] = (byte)(this.received.getBoolean(i) ? 1 : 0);
                }
                nbt.func_74773_a("Received", receivedArray);
            }
            nbt.func_74782_a("ToSend", (NBTBase)MiscUtil.saveAllItems(new NBTTagList(), this.toSend));
            if (this.facing != null) {
                nbt.func_74774_a("Facing", (byte)this.facing.func_176745_a());
            }
            return nbt;
        }
    }
}

