/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.api.item;

import gr8pefish.openglider.api.helper.GliderHelper;
import gr8pefish.openglider.api.item.IGlider;
import gr8pefish.openglider.common.helper.OpenGliderPlayerHelper;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateClientTarget;
import gr8pefish.openglider.common.util.OpenGliderHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHangGliderBase
extends Item
implements IGlider {
    private double horizSpeed;
    private double vertSpeed;
    private double shiftHorizSpeed;
    private double shiftVertSpeed;
    private double windMultiplier;
    private double airResistance;
    private int totalDurability;
    private ResourceLocation modelRL;

    public ItemHangGliderBase(double horizSpeed, double vertSpeed, double shiftHorizSpeed, double shiftVertSpeed, double windMultiplier, double airResistance, int totalDurability, ResourceLocation modelRL) {
        this.horizSpeed = horizSpeed;
        this.vertSpeed = vertSpeed;
        this.shiftHorizSpeed = shiftHorizSpeed;
        this.shiftVertSpeed = shiftVertSpeed;
        this.windMultiplier = windMultiplier;
        this.airResistance = airResistance;
        this.totalDurability = totalDurability;
        this.modelRL = modelRL;
        this.func_77656_e(totalDurability);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("status"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return this.isGlidingGlider(entityIn, stack) ? 1.0f : (ItemHangGliderBase.this.isBroken(stack) ? 2.0f : 0.0f);
            }

            private boolean isGlidingGlider(EntityLivingBase entityIn, ItemStack stack) {
                return entityIn != null && entityIn instanceof EntityPlayer && GliderHelper.getIsGliderDeployed((EntityPlayer)entityIn) && OpenGliderPlayerHelper.getGlider((EntityPlayer)entityIn) == stack;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack chestItem = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack itemStack = player.func_184586_b(hand);
        if (chestItem == null || chestItem.func_190926_b() || !(chestItem.func_77973_b() instanceof ItemElytra)) {
            if (this.isBroken(itemStack)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
            }
            if (!hand.equals((Object)EnumHand.MAIN_HAND)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
            }
            boolean isDeployed = GliderHelper.getIsGliderDeployed(player);
            GliderHelper.setIsGliderDeployed(player, !isDeployed);
            if (!world.field_72995_K) {
                EntityTracker tracker = world.func_73046_m().func_71218_a(player.field_71093_bK).func_73039_n();
                tracker.func_151247_a((Entity)player, PacketHandler.HANDLER.getPacketFrom((IMessage)new PacketUpdateClientTarget(player, GliderHelper.getIsGliderDeployed(player))));
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openglider.elytra.error", new Object[0]));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean isBroken(ItemStack stack) {
        return stack.func_77951_h() && stack.func_77952_i() >= stack.func_77958_k() - 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ArrayList<ItemStack> upgrades = OpenGliderHelper.getUpgradesFromNBT(stack);
        for (ItemStack upgrade : upgrades) {
            tooltip.add(upgrade.func_82833_r() + " " + I18n.func_135052_a((String)"openglider.tooltip.upgrade", (Object[])new Object[0]));
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        NonNullList leathers = OreDictionary.getOres((String)"leather");
        for (ItemStack stack : leathers) {
            if (stack.func_77973_b() != repair.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getHorizontalFlightSpeed() {
        return this.horizSpeed;
    }

    @Override
    public void setHorizontalFlightSpeed(double speed) {
        this.horizSpeed = speed;
    }

    @Override
    public double getVerticalFlightSpeed() {
        return this.vertSpeed;
    }

    @Override
    public void setVerticalFlightSpeed(double speed) {
        this.vertSpeed = speed;
    }

    @Override
    public double getShiftHorizontalFlightSpeed() {
        return this.shiftHorizSpeed;
    }

    @Override
    public void setShiftHorizontalFlightSpeed(double speed) {
        this.shiftHorizSpeed = speed;
    }

    @Override
    public double getShiftVerticalFlightSpeed() {
        return this.shiftVertSpeed;
    }

    @Override
    public void setShiftVerticalFlightSpeed(double speed) {
        this.shiftVertSpeed = speed;
    }

    @Override
    public double getWindMultiplier() {
        return this.windMultiplier;
    }

    @Override
    public void setWindMultiplier(double windMultiplierToSetTo) {
        this.windMultiplier = windMultiplierToSetTo;
    }

    @Override
    public double getAirResistance() {
        return this.airResistance;
    }

    @Override
    public void setAirResistance(double airResistanceToSetTo) {
        this.airResistance = airResistanceToSetTo;
    }

    @Override
    public int getTotalDurability() {
        return this.totalDurability;
    }

    @Override
    public void setTotalDurability(int durability) {
        this.totalDurability = durability;
    }

    @Override
    public int getCurrentDurability(ItemStack stack) {
        return stack.func_77952_i();
    }

    @Override
    public void setCurrentDurability(ItemStack stack, int durability) {
        this.setDamage(stack, durability);
        if (stack.func_77952_i() < 1) {
            stack.func_77964_b(1);
        }
    }

    @Override
    public ArrayList<ItemStack> getUpgrades(ItemStack glider) {
        return OpenGliderHelper.getUpgradesFromNBT(glider);
    }

    @Override
    public void removeUpgrade(ItemStack glider, ItemStack upgrade) {
    }

    @Override
    public void addUpgrade(ItemStack glider, ItemStack upgrade) {
    }

    @Override
    public ResourceLocation getModelTexture(ItemStack glider) {
        return this.modelRL;
    }

    @Override
    public void setModelTexture(ResourceLocation resourceLocation) {
        this.modelRL = resourceLocation;
    }

    public NBTTagCompound serializeNBT() {
        return null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }
}

