/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class GuiItemRenderer
extends Gui {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static final int DEFAULT_WIDTH = 16;
    public static final int HWIDTH = 8;
    public static final int DEFAULT_HEIGHT = 16;
    public static final int HHEIGHT = 8;
    protected int hwidth = 8;
    protected int hheight = 8;
    protected int width = 16;
    protected int height = 16;
    @Nonnull
    protected TextureAtlasSprite icon;
    @Nonnull
    protected ResourceLocation texture;
    private int yPosition;
    private int xPosition;
    private float alpha = 1.0f;

    public GuiItemRenderer(int x, int y, float alph, @Nonnull Item item, int itemMeta) {
        this.xPosition = x;
        this.yPosition = y;
        this.setAlpha(alph);
        this.icon = GuiItemRenderer.getIconForItem(item, itemMeta);
        this.texture = TextureMap.field_110575_b;
    }

    public GuiItemRenderer(int x, int y, float alph, @Nonnull TextureAtlasSprite icon, @Nonnull ResourceLocation texture) {
        this.xPosition = x;
        this.yPosition = y;
        this.setAlpha(alph);
        this.icon = icon;
        this.texture = texture;
    }

    @Nonnull
    public static TextureAtlasSprite getIconForItem(@Nonnull Item item, int meta) {
        TextureAtlasSprite icon = MC.func_175599_af().func_175037_a().func_178087_a(item, meta);
        return icon != null ? icon : MC.func_147117_R().func_174944_f();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.hwidth = width / 2;
        this.hheight = height / 2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Nonnull
    public TextureAtlasSprite getIcon() {
        return this.icon;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setIcon(@Nonnull TextureAtlasSprite icon) {
        this.icon = icon;
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(@Nonnull ResourceLocation textureName) {
        this.texture = textureName;
    }

    public static void bindTexture(String string) {
        GuiItemRenderer.MC.field_71446_o.func_110577_a(new ResourceLocation(string));
    }

    public static void bindTexture(@Nonnull ResourceLocation tex) {
        GuiItemRenderer.MC.field_71446_o.func_110577_a(tex);
    }

    public void draw() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GuiItemRenderer.bindTexture(this.texture);
        this.func_175175_a(this.xPosition, this.yPosition, this.icon, this.width, this.height);
        GlStateManager.func_179099_b();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

