/*
 * Decompiled with CFR 0.152.
 */
package dan.morefurnaces.inventory;

import dan.morefurnaces.FurnaceType;
import dan.morefurnaces.inventory.ItemHandlerFurnace;
import dan.morefurnaces.inventory.SlotFuel;
import dan.morefurnaces.inventory.SlotOutput;
import dan.morefurnaces.tileentity.TileEntityIronFurnace;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerIronFurnace
extends Container {
    private final FurnaceType type;
    private final TileEntityIronFurnace furnace;
    private final int[] lastCookTime;
    private int lastBurnTime = 0;
    private int lastItemBurnTime = 0;

    public ContainerIronFurnace(InventoryPlayer invPlayer, TileEntityIronFurnace invFurnace, FurnaceType type) {
        this.furnace = invFurnace;
        this.type = type;
        this.lastCookTime = new int[type.parallelSmelting];
        this.addFurnaceSlots(invPlayer);
        this.addPlayerSlots((IInventory)invPlayer);
    }

    private void addFurnaceSlots(InventoryPlayer inv) {
        block18: {
            int y;
            int x;
            int row;
            int col;
            ItemHandlerFurnace itemHandler;
            block20: {
                int y2;
                int x2;
                int slot;
                block19: {
                    int y3;
                    int x3;
                    int slot2;
                    block17: {
                        int y4;
                        int x4;
                        int col2;
                        int row2;
                        itemHandler = this.furnace.getItemHandler();
                        if (this.type.parallelSmelting == 1) break block17;
                        int index = 0;
                        for (row2 = 0; row2 < this.type.parallelSmelting; ++row2) {
                            for (col2 = 0; col2 < 2; ++col2) {
                                x4 = 56 - 18 * col2;
                                y4 = 17 + 26 * row2;
                                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, x4, y4));
                            }
                        }
                        for (int slot3 = 0; slot3 < 2; ++slot3) {
                            int x5 = 56 - 18 * slot3;
                            int y5 = 83;
                            this.func_75146_a((Slot)new SlotFuel(itemHandler, index++, x5, y5));
                        }
                        for (row2 = 0; row2 < 2; ++row2) {
                            for (col2 = 0; col2 < 2; ++col2) {
                                x4 = 116 + 22 * col2;
                                y4 = 18 + 26 * row2 + 4 * col2;
                                this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, x4, y4));
                            }
                        }
                        break block18;
                    }
                    if (this.type.getNumInputSlots() != 4) break block19;
                    int index = 0;
                    for (slot2 = 0; slot2 < this.type.getNumInputSlots(); ++slot2) {
                        x3 = 62 - 18 * slot2;
                        y3 = 17;
                        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, x3, y3));
                    }
                    for (slot2 = 0; slot2 < this.type.getNumFuelSlots(); ++slot2) {
                        x3 = 62 - 18 * slot2;
                        y3 = 53;
                        this.func_75146_a((Slot)new SlotFuel(itemHandler, index++, x3, y3));
                    }
                    this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, 112, 35));
                    for (int row3 = 0; row3 < 2; ++row3) {
                        for (int col3 = 0; col3 < 2; ++col3) {
                            int x6 = 134 + 18 * col3;
                            int y6 = 26 + 18 * row3;
                            this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, x6, y6));
                        }
                    }
                    break block18;
                }
                if (this.type.getNumFuelSlots() >= 3) break block20;
                int index = 0;
                for (slot = 0; slot < this.type.getNumInputSlots(); ++slot) {
                    x2 = 56 - 18 * slot;
                    y2 = 17;
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, x2, y2));
                }
                for (slot = 0; slot < this.type.getNumFuelSlots(); ++slot) {
                    x2 = 56 - 18 * slot;
                    y2 = 53;
                    this.func_75146_a((Slot)new SlotFuel(itemHandler, index++, x2, y2));
                }
                this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, 116, 35));
                if (this.type.getNumOutputSlots() != 2) break block18;
                this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index, 138, 39));
                break block18;
            }
            int index = 0;
            for (col = 0; col < 4; ++col) {
                for (row = 0; row < 2; ++row) {
                    if (col == 0 && row == 1) continue;
                    x = 62 - 18 * col;
                    y = 35 - 18 * row;
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, x, y));
                }
            }
            for (col = 0; col < 4; ++col) {
                for (row = 0; row < 2; ++row) {
                    if (col == 0 && row == 1) continue;
                    x = 62 - 18 * col;
                    y = 71 + 18 * row;
                    this.func_75146_a((Slot)new SlotFuel(itemHandler, index++, x, y));
                }
            }
            this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, 112, 53));
            for (col = 0; col < 2; ++col) {
                for (row = 0; row < 4; ++row) {
                    x = 134 + 18 * col;
                    y = 26 + 18 * row;
                    this.func_75146_a((Slot)new SlotOutput(inv.field_70458_d, (IItemHandlerModifiable)itemHandler, index++, x, y));
                }
            }
        }
    }

    private void addPlayerSlots(IInventory inv) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + this.type.invStartY;
                this.func_75146_a(new Slot(inv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 58 + this.type.invStartY;
            this.func_75146_a(new Slot(inv, row, x, y));
        }
    }

    public TileEntityIronFurnace getTileEntity() {
        return this.furnace;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            for (int i = 0; i < this.type.parallelSmelting; ++i) {
                if (this.lastCookTime[i] == this.furnace.furnaceCookTime[i]) continue;
                listener.func_71112_a((Container)this, i, this.furnace.furnaceCookTime[i]);
            }
            if (this.lastBurnTime != this.furnace.furnaceBurnTime) {
                listener.func_71112_a((Container)this, this.type.parallelSmelting, this.furnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.furnace.currentItemBurnTime) continue;
            listener.func_71112_a((Container)this, this.type.parallelSmelting + 1, this.furnace.currentItemBurnTime);
        }
        System.arraycopy(this.furnace.furnaceCookTime, 0, this.lastCookTime, 0, this.type.parallelSmelting);
        this.lastBurnTime = this.furnace.furnaceBurnTime;
        this.lastItemBurnTime = this.furnace.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (i < this.type.parallelSmelting) {
            this.furnace.furnaceCookTime[i] = j;
        }
        if (i == this.type.parallelSmelting) {
            this.furnace.furnaceBurnTime = j;
        }
        if (i == this.type.parallelSmelting + 1) {
            this.furnace.currentItemBurnTime = j;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        BlockPos pos = this.furnace.func_174877_v();
        return player.field_70170_p.func_175625_s(pos) == this.furnace && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    private boolean isOutputSlot(int i) {
        return i >= this.type.getFirstOutputSlot(0) && i <= this.type.getLastOutputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isInputSlot(int i) {
        return i >= 0 && i <= this.type.getLastInputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isFuelSlot(int i) {
        return i >= this.type.getFirstFuelSlot() && i <= this.type.getLastFuelSlot();
    }

    protected boolean transferStackInSlot(Slot slot, int index, ItemStack stack1, ItemStack stack) {
        if (this.isOutputSlot(index)) {
            if (!this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, true)) {
                return true;
            }
            slot.func_75220_a(stack1, stack);
        } else if (!this.isInputSlot(index) && !this.isFuelSlot(index) ? (!FurnaceRecipes.func_77602_a().func_151395_a(stack1).func_190926_b() ? !this.func_75135_a(stack1, 0, this.type.getFirstFuelSlot(), false) : (TileEntityFurnace.func_145954_b((ItemStack)stack1) ? !this.func_75135_a(stack1, this.type.getFirstFuelSlot(), this.type.getFirstOutputSlot(0), false) : (index >= this.type.getNumSlots() && index < this.type.getNumSlots() + 27 ? !this.func_75135_a(stack1, this.type.getNumSlots() + 27, this.type.getNumSlots() + 36, false) : index >= this.type.getNumSlots() + 27 && index < this.type.getNumSlots() + 36 && !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 27, false)))) : !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, false)) {
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            if (this.transferStackInSlot(slot, index, stack1, stack = stack1.func_77946_l())) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack1);
        }
        return stack;
    }
}

