/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.interpolation.CubicInterpolation;
import com.creativemd.creativecore.common.utils.math.interpolation.HermiteInterpolation;
import com.creativemd.creativecore.common.utils.math.interpolation.LinearInterpolation;
import com.creativemd.creativecore.common.utils.math.vec.Vec;
import com.creativemd.creativecore.common.utils.math.vec.Vec2;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleShapeCurveWall
extends LittleShape {
    private static String[] interpolationTypes = new String[]{"hermite", "cubic", "linear"};

    public LittleShapeCurveWall() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        HermiteInterpolation interpolation;
        int direction = selection.getNBT().func_74762_e("direction");
        LittleBox overallBox = selection.getOverallBox();
        EnumFacing.Axis axis = direction == 0 ? EnumFacing.Axis.Y : (direction == 1 ? EnumFacing.Axis.X : EnumFacing.Axis.Z);
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        double halfPixelSize = selection.getContext().pixelSize * 0.5;
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            LittleGridContext context = pos.getContext();
            points.add(new Vec2(pos.pos.getVanillaGrid(one) + halfPixelSize, pos.pos.getVanillaGrid(two)));
        }
        int thickness = Math.max(0, selection.getNBT().func_74762_e("thickness") - 1);
        if (points.size() <= 1) {
            LittleBox box = selection.getOverallBox();
            box.growCentered(thickness);
            boxes.add(box);
            return;
        }
        switch (selection.getNBT().func_74762_e("interpolation")) {
            case 0: {
                interpolation = new HermiteInterpolation((Vec[])points.toArray(new Vec2[0]));
                break;
            }
            case 1: {
                interpolation = new CubicInterpolation((Vec[])points.toArray(new Vec2[0]));
                break;
            }
            default: {
                interpolation = new LinearInterpolation((Vec[])points.toArray(new Vec2[0]));
            }
        }
        Vec2 origin = new Vec2((double)VectorUtils.get((EnumFacing.Axis)one, (Vec3i)boxes.pos), (double)VectorUtils.get((EnumFacing.Axis)two, (Vec3i)boxes.pos));
        int amount = 0;
        double pointTime = 1.0 / (double)(points.size() - 1);
        double currentTime = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec2 before = (Vec2)points.get(i);
            Vec2 end = (Vec2)points.get(i + 1);
            Vec2 middle = (Vec2)interpolation.valueAt(pointTime * ((double)i + 0.5));
            double distance = before.distance((Vec)middle) + middle.distance((Vec)end);
            int stepCount = (int)Math.ceil(distance / boxes.context.pixelSize * 2.0);
            double stepSize = pointTime / (double)(stepCount - 1);
            for (int j = 0; j < stepCount; ++j) {
                Vec2 vec = (Vec2)((Vec2)interpolation.valueAt(pointTime * (double)i + stepSize * (double)j)).sub((Vec)origin);
                LittleVec point = new LittleVec(0, 0, 0);
                point.set(one, boxes.context.toGrid(vec.x));
                point.set(two, boxes.context.toGrid(vec.y));
                LittleBox box = new LittleBox(point);
                box.setMin(axis, overallBox.getMin(axis));
                box.setMax(axis, overallBox.getMax(axis));
                box.growCentered(thickness);
                boxes.add(box);
                ++amount;
            }
        }
    }

    @Override
    public boolean requiresNoOverlap() {
        return true;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("interpolation: " + interpolationTypes[nbt.func_74762_e("interpolation")]);
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        controls.add((GuiControl)new GuiStateButton("interpolation", nbt.func_74762_e("interpolation"), 60, 30, 40, 7, interpolationTypes));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 27, new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
        nbt.func_74768_a("interpolation", ((GuiStateButton)gui.get("interpolation")).getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

