/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.drag;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.drag.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeWall
extends DragShape {
    public DragShapeWall() {
        super("wall");
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, LittleBox box) {
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        BoxCorner[] corners = BoxCorner.faceCorners((EnumFacing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
        }
    }

    @Override
    public LittleBoxes getBoxes(LittleBoxes boxes, LittleVec min, LittleVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, PlacementPosition originalMin, PlacementPosition originalMax) {
        int direction = nbt.func_74762_e("direction");
        if (nbt.func_74767_n("smooth")) {
            originalMin.convertTo(boxes.getContext());
            originalMax.convertTo(boxes.getContext());
            int thickness = Math.max(0, nbt.func_74762_e("thickness") - 1);
            LittleTransformableBox box = new LittleTransformableBox(new LittleBox(min, max), new int[0]);
            EnumFacing.Axis toIgnore = direction == 0 ? EnumFacing.Axis.Y : (direction == 1 ? EnumFacing.Axis.X : EnumFacing.Axis.Z);
            EnumFacing.Axis oneIgnore = RotationUtils.getOne((EnumFacing.Axis)toIgnore);
            EnumFacing.Axis twoIgnore = RotationUtils.getTwo((EnumFacing.Axis)toIgnore);
            EnumFacing.Axis axis = box.getSize(oneIgnore) > box.getSize(twoIgnore) ? oneIgnore : twoIgnore;
            LittleTransformableBox littleTransformableBox = box;
            littleTransformableBox.getClass();
            LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
            LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
            LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            LittleBox minBox = new LittleBox(originalMinVec);
            LittleBox maxBox = new LittleBox(originalMaxVec);
            minBox.growCentered(thickness);
            maxBox.growCentered(thickness);
            minBox.setMin(toIgnore, box.getMin(toIgnore));
            maxBox.setMin(toIgnore, box.getMin(toIgnore));
            minBox.setMax(toIgnore, box.getMax(toIgnore));
            maxBox.setMax(toIgnore, box.getMax(toIgnore));
            box.growToInclude(minBox);
            box.growToInclude(maxBox);
            boolean facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
            this.shrinkEdge(cache, axis, one, two, facingPositive, minBox);
            this.shrinkEdge(cache, axis, one, two, !facingPositive, maxBox);
            box.setData(cache.getData());
            boxes.add(box);
            return boxes;
        }
        int thicknessXInv = 0;
        int thicknessX = 0;
        int thicknessYInv = nbt.func_74762_e("thickness") > 1 ? (int)Math.ceil((double)(nbt.func_74762_e("thickness") - 1) / 2.0) : 0;
        int thicknessY = nbt.func_74762_e("thickness") > 1 ? (int)Math.floor((double)(nbt.func_74762_e("thickness") - 1) / 2.0) : 0;
        LittleBox box = new LittleBox(min, max);
        LittleAbsoluteVec absolute = new LittleAbsoluteVec(boxes.pos, boxes.context);
        LittleVec originalMinVec = originalMin.getRelative(absolute).getVec(boxes.context);
        LittleVec originalMaxVec = originalMax.getRelative(absolute).getVec(boxes.context);
        int w = originalMaxVec.x - originalMinVec.x;
        int h = originalMaxVec.z - originalMinVec.z;
        int x = originalMinVec.x;
        int y = originalMinVec.z;
        if (direction == 1) {
            w = originalMaxVec.y - originalMinVec.y;
            h = originalMaxVec.z - originalMinVec.z;
            x = originalMinVec.y;
            y = originalMinVec.z;
        } else if (direction == 2) {
            w = originalMaxVec.x - originalMinVec.x;
            h = originalMaxVec.y - originalMinVec.y;
            x = originalMinVec.x;
            y = originalMinVec.y;
        }
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
            thicknessX = thicknessY;
            thicknessXInv = thicknessYInv;
            thicknessY = 0;
            thicknessYInv = 0;
        }
        int numerator = longest >> 1;
        for (int i = 0; i <= longest; ++i) {
            LittleBox toAdd = null;
            switch (direction) {
                case 0: {
                    toAdd = new LittleBox(x - thicknessXInv, box.minY, y - thicknessYInv, x + thicknessX + 1, box.maxY, y + thicknessY + 1);
                    break;
                }
                case 1: {
                    toAdd = new LittleBox(box.minX, x - thicknessXInv, y - thicknessYInv, box.maxX, x + thicknessX + 1, y + thicknessY + 1);
                    break;
                }
                case 2: {
                    toAdd = new LittleBox(x - thicknessXInv, y - thicknessYInv, box.minZ, x + thicknessX + 1, y + thicknessY + 1, box.maxZ);
                }
            }
            boxes.add(toAdd);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x += dx1;
                y += dy1;
                continue;
            }
            x += dx2;
            y += dy2;
        }
        LittleBox.combineBoxesBlocks((LittleBoxes)boxes);
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 27, new String[]{"facing: y", "facing: x", "facing: z"}));
        controls.add((GuiControl)new GuiCheckBox("smooth", 60, 27, nbt.func_74767_n("smooth")));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
        GuiCheckBox box = (GuiCheckBox)gui.get("smooth");
        nbt.func_74757_a("smooth", box.value);
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

