/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.selection.mode;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.config.LittleBuildingConfig;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.selection.mode.SelectionMode;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class AreaSelectionMode
extends SelectionMode {
    public AreaSelectionMode() {
        super("area");
    }

    @Override
    public SelectionMode.SelectionResult generateResult(World world, ItemStack stack) {
        BlockPos pos = null;
        if (stack.func_77978_p().func_74764_b("pos1")) {
            int[] array = stack.func_77978_p().func_74759_k("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (stack.func_77978_p().func_74764_b("pos2")) {
            int[] array = stack.func_77978_p().func_74759_k("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        SelectionMode.SelectionResult result = new SelectionMode.SelectionResult(world);
        result.addBlocks(pos, pos2);
        return result;
    }

    @Override
    public void onLeftClick(EntityPlayer player, ItemStack stack, BlockPos pos) {
        stack.func_77978_p().func_74783_a("pos1", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("selection.mode.area.pos.first", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }

    @Override
    public void onRightClick(EntityPlayer player, ItemStack stack, BlockPos pos) {
        stack.func_77978_p().func_74783_a("pos2", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("selection.mode.area.pos.second", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }

    @Override
    public void clearSelection(ItemStack stack) {
        stack.func_77978_p().func_82580_o("pos1");
        stack.func_77978_p().func_82580_o("pos2");
    }

    public LittlePreviews getPreviews(World world, BlockPos pos, BlockPos pos2, boolean includeVanilla, boolean includeCB, boolean includeLT, boolean rememberStructure) {
        int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
        int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
        int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
        int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
        LittlePreviews previews = new LittlePreviews(LittleGridContext.getMin());
        boolean includeTE = includeCB || includeLT;
        BlockPos center = new BlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        ArrayList<LittleStructure> structures = null;
        if (rememberStructure) {
            structures = new ArrayList<LittleStructure>();
        }
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    IBlockState state;
                    LittlePreview preview;
                    newPos.func_181079_c(posX, posY, posZ);
                    if (includeTE) {
                        LittlePreviews specialPreviews;
                        TileEntity tileEntity = world.func_175625_s((BlockPos)newPos);
                        if (includeLT && tileEntity instanceof TileEntityLittleTiles) {
                            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                            for (IParentTileList parent : te.groups()) {
                                if (rememberStructure && parent.isStructure()) {
                                    try {
                                        LittleStructure structure = parent.getStructure();
                                        while (structure.getParent() != null) {
                                            structure = structure.getParent().getStructure();
                                        }
                                        structure.load();
                                        if (structures.contains(structure)) continue;
                                        previews.addChild(structure.getPreviews(center), false);
                                        structures.add(structure);
                                    }
                                    catch (CorruptedConnectionException | NotYetConnectedException e) {}
                                    continue;
                                }
                                for (LittleTile tile : parent) {
                                    LittlePreview preview2 = previews.addPreview(null, tile.getPreviewTile(), te.getContext());
                                    preview2.box.add(new LittleVec((posX - minX) * previews.getContext().size, (posY - minY) * previews.getContext().size, (posZ - minZ) * previews.getContext().size));
                                }
                            }
                        }
                        if (includeCB && (specialPreviews = ChiselsAndBitsManager.getPreviews(tileEntity)) != null) {
                            for (int i = 0; i < specialPreviews.size(); ++i) {
                                preview = previews.addPreview(null, specialPreviews.get(i), LittleGridContext.get(ChiselsAndBitsManager.convertingFrom));
                                preview.box.add(new LittleVec((posX - minX) * previews.getContext().size, (posY - minY) * previews.getContext().size, (posZ - minZ) * previews.getContext().size));
                            }
                            continue;
                        }
                    }
                    if (!includeVanilla || !LittleAction.isBlockValid(state = world.func_180495_p((BlockPos)newPos))) continue;
                    LittleTile tile = new LittleTile(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    int minSize = LittleGridContext.getMin().size;
                    tile.setBox(new LittleBox(0, 0, 0, minSize, minSize, minSize));
                    preview = previews.addPreview(null, tile.getPreviewTile(), LittleGridContext.getMin());
                    preview.box.add(new LittleVec((posX - minX) * previews.getContext().size, (posY - minY) * previews.getContext().size, (posZ - minZ) * previews.getContext().size));
                }
            }
        }
        return previews;
    }

    @Override
    public LittlePreviews getPreviews(World world, EntityPlayer player, ItemStack stack, boolean includeVanilla, boolean includeCB, boolean includeLT, boolean rememberStructure) throws LittleActionException {
        BlockPos pos = null;
        if (stack.func_77978_p().func_74764_b("pos1")) {
            int[] array = stack.func_77978_p().func_74759_k("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (stack.func_77978_p().func_74764_b("pos2")) {
            int[] array = stack.func_77978_p().func_74759_k("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
        int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
        int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
        int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
        if (((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)player)).limitRecipeSize && (maxX - minX) * (maxY - minY) * (maxZ - minZ) > ((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)player)).recipeBlocksLimit) {
            throw new LittleTilesConfig.AreaTooLarge(player);
        }
        LittlePreviews previews = this.getPreviews(world, pos, pos2, includeVanilla, includeCB, includeLT, rememberStructure);
        BlockPos center = new BlockPos(minX, minY, minZ);
        ArrayList<LittleStructure> structures = null;
        if (rememberStructure) {
            structures = new ArrayList<LittleStructure>();
        }
        for (EntityAnimation animation : WorldAnimationHandler.getHandler(world).findAnimations(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)))) {
            if (rememberStructure) {
                try {
                    LittleStructure structure = animation.structure;
                    while (structure.getParent() != null) {
                        structure = structure.getParent().getStructure();
                    }
                    structure.load();
                    if (structures.contains(structure)) continue;
                    previews.addChild(structure.getPreviews(center), false);
                    structures.add(structure);
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {}
                continue;
            }
            try {
                for (Pair<IStructureTileList, LittleTile> pair : animation.structure.tiles()) {
                    LittlePreview preview = previews.addPreview(null, ((LittleTile)pair.value).getPreviewTile(), ((IStructureTileList)pair.getKey()).getContext());
                    preview.box.add(new LittleVec((((IStructureTileList)pair.key).getPos().func_177958_n() - minX) * previews.getContext().size, (((IStructureTileList)pair.key).getPos().func_177956_o() - minY) * previews.getContext().size, (((IStructureTileList)pair.key).getPos().func_177952_p() - minZ) * previews.getContext().size));
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            }
        }
        return previews;
    }
}

