/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.vec;

import com.creativemd.littletiles.common.tile.math.vec.LittleVec;

public class LittleRay {
    public LittleVec origin = new LittleVec(0, 0, 0);
    public LittleVec direction = new LittleVec(0, 0, 0);

    public LittleRay(LittleVec start, LittleVec end) {
        this.set(start, end);
    }

    public void set(LittleVec start, LittleVec end) {
        this.origin.set(start.x, start.y, start.z);
        this.direction.x = end.x - start.x;
        this.direction.y = end.y - start.y;
        this.direction.z = end.z - start.z;
    }

    public boolean parallel(LittleRay other) {
        int scaleOther;
        int scale;
        if (this.direction.x > 0 != other.direction.x > 0 || this.direction.y > 0 != other.direction.y > 0 || this.direction.z > 0 != other.direction.z > 0) {
            return false;
        }
        if (this.direction.x != 0) {
            scale = other.direction.x;
            scaleOther = this.direction.x;
        } else if (this.direction.y != 0) {
            scale = other.direction.y;
            scaleOther = this.direction.y;
        } else {
            scale = other.direction.z;
            scaleOther = this.direction.z;
        }
        return this.direction.x * scale == other.direction.x * scaleOther && this.direction.y * scale == other.direction.y * scaleOther && this.direction.z * scale == other.direction.z * scaleOther;
    }

    public String toString() {
        return "o:" + this.origin + ",d:" + this.direction;
    }
}

