/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.item.ItemLittleWrench;
import com.creativemd.littletiles.common.particle.LittleParticle;
import com.creativemd.littletiles.common.particle.LittleParticlePresets;
import com.creativemd.littletiles.common.particle.LittleParticleTexture;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewFacing;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleParticleEmitter
extends LittleStructurePremade {
    @StructureDirectional
    public EnumFacing facing = EnumFacing.UP;
    public ParticleSettings settings = new ParticleSettings();
    public ParticleSpread spread = new ParticleSpreadRandom();
    public int delay = 10;
    public int count = 1;
    protected int ticker = 0;
    @SideOnly(value=Side.CLIENT)
    private static Method spawnParticle0;
    @SideOnly(value=Side.CLIENT)
    private static Field particleMaxAge;
    private static List<Function<NBTTagCompound, ParticleSpread>> parser;

    public LittleParticleEmitter(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public void tick() {
        if (this.getOutput(0).getState()[0]) {
            return;
        }
        if (this.ticker >= this.delay) {
            if (this.getWorld().field_72995_K) {
                for (int i = 0; i < this.count; ++i) {
                    this.spawnParticle(this.getWorld());
                }
            }
            this.ticker = 0;
        } else {
            ++this.ticker;
        }
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!worldIn.field_72995_K) {
            LittleStructureGuiHandler.openGui("particle", new NBTTagCompound(), playerIn, this);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(World world) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ItemLittleWrench || Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() instanceof ItemLittleWrench) {
            return;
        }
        if (spawnParticle0 == null) {
            spawnParticle0 = ReflectionHelper.findMethod(RenderGlobal.class, (String)"spawnParticle0", (String)"func_190571_b", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, int[].class});
        }
        if (particleMaxAge == null) {
            particleMaxAge = ReflectionHelper.findField(Particle.class, (String[])new String[]{"particleMaxAge", "field_70547_e"});
        }
        try {
            AxisAlignedBB bb = this.getSurroundingBox().getAABB();
            Vector3d pos = new Vector3d(0.0, 0.5, 0.0);
            Vector3d speed = this.spread.generate();
            Rotation rotation = null;
            switch (this.facing) {
                case DOWN: {
                    pos.scale(-1.0);
                    speed.scale(-1.0);
                    break;
                }
                case EAST: {
                    rotation = Rotation.Z_COUNTER_CLOCKWISE;
                    break;
                }
                case WEST: {
                    rotation = Rotation.Z_CLOCKWISE;
                    break;
                }
                case SOUTH: {
                    rotation = Rotation.X_CLOCKWISE;
                    break;
                }
                case NORTH: {
                    rotation = Rotation.X_COUNTER_CLOCKWISE;
                }
            }
            if (rotation != null) {
                RotationUtils.rotate((Vector3d)pos, (Rotation)rotation);
                RotationUtils.rotate((Vector3d)speed, (Rotation)rotation);
            }
            pos.x *= bb.field_72336_d - bb.field_72340_a;
            pos.y *= bb.field_72337_e - bb.field_72338_b;
            pos.z *= bb.field_72334_f - bb.field_72339_c;
            pos.x += (bb.field_72340_a + bb.field_72336_d) / 2.0;
            pos.y += (bb.field_72338_b + bb.field_72337_e) / 2.0;
            pos.z += (bb.field_72339_c + bb.field_72334_f) / 2.0;
            if (world instanceof IOrientatedWorld) {
                ((IOrientatedWorld)world).getOrigin().transformPointToWorld(pos);
                ((IOrientatedWorld)world).getOrigin().onlyRotateWithoutCenter(speed);
            }
            mc.field_71452_i.func_78873_a((Particle)new LittleParticle(world, pos, speed, this.settings));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSettings(NBTTagCompound nbt) {
        this.spread = LittleParticleEmitter.loadSpread(nbt);
        this.delay = nbt.func_74762_e("tickDelay");
        this.ticker = nbt.func_74762_e("ticker");
        this.count = nbt.func_74764_b("tickCount") ? nbt.func_74762_e("tickCount") : 1;
        this.settings = nbt.func_74764_b("settings") ? new ParticleSettings(nbt.func_74775_l("settings")) : LittleParticlePresets.SMOKE.settings.copy();
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.loadSettings(nbt);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("tickDelay", this.delay);
        nbt.func_74768_a("tickCount", this.count);
        nbt.func_74768_a("ticker", this.ticker);
        this.spread.write(nbt);
        NBTTagCompound settingsData = new NBTTagCompound();
        this.settings.write(settingsData);
        nbt.func_74782_a("settings", (NBTBase)settingsData);
    }

    public static ParticleSpread loadSpread(NBTTagCompound nbt) {
        ParticleSpread spread = null;
        for (int i = parser.size() - 1; i >= 0 && (spread = parser.get(i).apply(nbt)) == null; --i) {
        }
        if (spread == null) {
            spread = new ParticleSpreadRandom();
        }
        spread.speedY = nbt.func_74760_g("speedY");
        spread.spread = nbt.func_74760_g("spread");
        return spread;
    }

    public static void registerParticleSpreadParser(Function<NBTTagCompound, ParticleSpread> function) {
        parser.add(function);
    }

    static {
        parser = new ArrayList<Function<NBTTagCompound, ParticleSpread>>();
        LittleParticleEmitter.registerParticleSpreadParser(x -> {
            ParticleSpreadRandom spread = new ParticleSpreadRandom();
            spread.speedX = x.func_74760_g("speedX");
            spread.speedZ = x.func_74760_g("speedZ");
            return spread;
        });
        LittleParticleEmitter.registerParticleSpreadParser(x -> {
            if (!x.func_74764_b("radius")) {
                return null;
            }
            ParticleSpreadCircular spread = new ParticleSpreadCircular();
            spread.radius = x.func_74760_g("radius");
            spread.angle = x.func_74760_g("angle");
            spread.steps = x.func_74762_e("steps");
            return spread;
        });
    }

    public static class LittleStructureTypeParticleEmitter
    extends LittleStructurePremade.LittleStructureTypePremade {
        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> cubes;

        public LittleStructureTypeParticleEmitter(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid) {
            super(id, category, structureClass, attribute, modid);
        }

        @Override
        public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
            List<PlacePreview> result = super.getSpecialTiles(previews);
            EnumFacing facing = (EnumFacing)this.loadDirectional(previews, "facing");
            LittleBox box = previews.getSurroundingBox();
            result.add(new PlacePreviewFacing(box, facing, -65536));
            return result;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            if (this.cubes == null) {
                this.cubes = new ArrayList<RenderBox>();
                this.cubes.add(new RenderBox(0.2f, 0.2f, 0.2f, 0.8f, 0.8f, 0.8f, (Block)LittleTiles.dyeableBlock).setColor(-13619152));
            }
            return this.cubes;
        }
    }

    public static class ParticleSpreadCircular
    extends ParticleSpread {
        public float radius = 0.1f;
        public float angle = 0.0f;
        public int steps = 30;

        public ParticleSpreadCircular() {
        }

        public ParticleSpreadCircular(float power, float radius, float angle, int steps, float deviation) {
            this.speedY = power;
            this.radius = radius;
            this.angle = angle;
            this.steps = steps;
            this.spread = deviation;
        }

        @Override
        protected void populate(Vector3d vec) {
            vec.x = Math.cos(this.angle) * (double)this.radius;
            vec.z = Math.sin(this.angle) * (double)this.radius;
            this.angle = (float)((double)this.angle + Math.PI * 2 / (double)this.steps);
        }

        @Override
        public void write(NBTTagCompound nbt) {
            super.write(nbt);
            nbt.func_74776_a("radius", this.radius);
            nbt.func_74776_a("degree", this.angle);
            nbt.func_74768_a("steps", this.steps);
        }
    }

    public static class ParticleSpreadRandom
    extends ParticleSpread {
        public float speedX = 0.0f;
        public float speedZ = 0.0f;

        public ParticleSpreadRandom() {
        }

        public ParticleSpreadRandom(float power, float x, float z, float deviation) {
            this.speedY = power;
            this.speedX = x;
            this.speedZ = z;
            this.spread = deviation;
        }

        @Override
        protected void populate(Vector3d vec) {
            vec.x = this.speedX;
            vec.z = this.speedZ;
        }

        @Override
        public void write(NBTTagCompound nbt) {
            super.write(nbt);
            nbt.func_74776_a("speedX", this.speedX);
            nbt.func_74776_a("speedZ", this.speedZ);
        }
    }

    public static abstract class ParticleSpread {
        public float speedY = 0.1f;
        public float spread = 0.1f;

        protected abstract void populate(Vector3d var1);

        public Vector3d generate() {
            Vector3d vec = new Vector3d();
            vec.y = this.speedY;
            this.populate(vec);
            float half = this.spread / 2.0f;
            vec.x += Math.random() * (double)this.spread - (double)half;
            vec.y += Math.random() * (double)this.spread - (double)half;
            vec.z += Math.random() * (double)this.spread - (double)half;
            return vec;
        }

        public void write(NBTTagCompound nbt) {
            nbt.func_74776_a("speedY", this.speedY);
            nbt.func_74776_a("spread", this.spread);
        }
    }

    public static class ParticleSettings {
        public float gravity = 0.0f;
        public int color = ColorUtils.RGBAToInt((int)20, (int)20, (int)20, (int)255);
        public int lifetime = 40;
        public int lifetimeDeviation = 5;
        public float startSize = 0.4f;
        public float endSize = 0.5f;
        public float sizeDeviation = 0.04f;
        public LittleParticleTexture texture = LittleParticleTexture.dust_fade_out;
        public boolean randomColor = false;

        public ParticleSettings() {
        }

        public ParticleSettings(float gravity, int color, int lifetime, int lifetimeDeviation, float startSize, float endSize, float sizeDeviation, LittleParticleTexture texture, boolean randomColor) {
            this.gravity = gravity;
            this.color = color;
            this.lifetime = lifetime;
            this.lifetimeDeviation = lifetimeDeviation;
            this.startSize = startSize;
            this.endSize = endSize;
            this.sizeDeviation = sizeDeviation;
            this.texture = texture;
            this.randomColor = randomColor;
        }

        public ParticleSettings(NBTTagCompound nbt) {
            this.gravity = nbt.func_74760_g("gravity");
            this.color = nbt.func_74762_e("color");
            this.lifetime = nbt.func_74762_e("lifetime");
            this.lifetimeDeviation = nbt.func_74762_e("lifetimeDeviation");
            this.startSize = nbt.func_74760_g("startSize");
            this.endSize = nbt.func_74760_g("endSize");
            this.sizeDeviation = nbt.func_74760_g("sizeDeviation");
            this.randomColor = nbt.func_74767_n("randomColor");
            this.texture = LittleParticleTexture.get(nbt.func_74779_i("texture"));
        }

        public void write(NBTTagCompound nbt) {
            nbt.func_74776_a("gravity", this.gravity);
            nbt.func_74768_a("color", this.color);
            nbt.func_74768_a("lifetime", this.lifetime);
            nbt.func_74768_a("lifetimeDeviation", this.lifetimeDeviation);
            nbt.func_74776_a("startSize", this.startSize);
            nbt.func_74776_a("endSize", this.endSize);
            nbt.func_74776_a("sizeDeviation", this.sizeDeviation);
            nbt.func_74778_a("texture", this.texture.name());
            nbt.func_74757_a("randomColor", this.randomColor);
        }

        public ParticleSettings copy() {
            return new ParticleSettings(this.gravity, this.color, this.lifetime, this.lifetimeDeviation, this.startSize, this.endSize, this.sizeDeviation, this.texture, this.randomColor);
        }
    }
}

