/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.schedule;

import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.schedule.SignalTicker;
import net.minecraft.world.World;

public interface ISignalSchedulable {
    public void notifyChange();

    public boolean hasChanged();

    public void markChanged();

    public void markUnchanged();

    public World getWorld();

    public boolean isStillAvailable();

    default public void updateSignaling() throws CorruptedConnectionException, NotYetConnectedException {
        this.markUnchanged();
        this.notifyChange();
    }

    default public void schedule() {
        if (!this.hasChanged() && this.isStillAvailable()) {
            SignalTicker.schedule(this.getWorld(), this);
            this.markChanged();
        }
    }
}

