/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import java.text.ParseException;

public class SignalPatternParser {
    public final String pattern;
    private int pos = -1;

    public SignalPatternParser(String pattern) {
        this.pattern = pattern;
    }

    public boolean hasNext() {
        return this.pos < this.pattern.length() - 1;
    }

    public char next(boolean skipSpace) throws ParseException {
        try {
            if (skipSpace) {
                char next = ' ';
                while (Character.isWhitespace(next)) {
                    next = this.pattern.charAt(++this.pos);
                }
                return next;
            }
            return this.pattern.charAt(++this.pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.exception("Invalid end of pattern");
        }
    }

    public char lookForNext(boolean skipSpace) {
        if (skipSpace) {
            char next = ' ';
            int index = this.pos;
            while (this.hasNext() && Character.isWhitespace(next)) {
                next = this.pattern.charAt(++index);
            }
            return next;
        }
        if (this.hasNext()) {
            return this.pattern.charAt(this.pos + 1);
        }
        return '\n';
    }

    public int parseNumber() throws ParseException {
        String digit = "";
        boolean first = true;
        while (Character.isDigit(this.lookForNext(first))) {
            digit = digit + this.next(first);
            first = false;
        }
        try {
            return Integer.parseInt(digit);
        }
        catch (NumberFormatException e) {
            throw this.exception("Invalid number " + digit);
        }
    }

    public int position() {
        return this.pos;
    }

    public ParseException exception(String text) {
        return new ParseException(text + " '" + this.pattern + "'", this.pos);
    }

    public ParseException invalidChar(char character) {
        return this.exception("Invalid char " + character);
    }

    public char current() {
        return this.pattern.charAt(this.pos);
    }
}

