/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.logic.SignalCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalConditionChild;
import com.creativemd.littletiles.common.structure.signal.logic.SignalConditionExternal;
import com.creativemd.littletiles.common.structure.signal.logic.SignalConditionInternal;
import java.text.ParseException;
import java.util.ArrayList;

public abstract class SignalCondition {
    public static SignalCondition parse(String pattern) throws ParseException {
        return SignalCondition.parseExpression(new Parser(pattern), '\n', PatternOperator.HIGHEST);
    }

    public static SignalCondition parseNextCondition(Parser parser) throws ParseException {
        while (parser.hasNext()) {
            char current = parser.next();
            if (current == ' ') continue;
            int type = Character.getType(current);
            if (current == '(') {
                return SignalCondition.parseExpression(parser, ')', PatternOperator.HIGHEST);
            }
            if (current == '!') {
                return new SignalConditionNot(SignalCondition.parseNextCondition(parser));
            }
            if (type == 2) {
                return SignalCondition.parseInput(current, parser);
            }
            if (type == 1) {
                return SignalCondition.parseInput(Character.toLowerCase(current), parser);
            }
            throw new ParseException("Invalid signal pattern " + parser.pattern, parser.position());
        }
        throw new ParseException("Invalid signal pattern " + parser.pattern, parser.position());
    }

    private static SignalCondition parseLower(Parser parser, char until, PatternOperator operator) throws ParseException {
        if (operator.lower() != null) {
            return SignalCondition.parseExpression(parser, until, operator.lower());
        }
        return SignalCondition.parseNextCondition(parser);
    }

    public static SignalCondition parseExpression(Parser parser, char until, PatternOperator operator) throws ParseException {
        SignalCondition first = SignalCondition.parseLower(parser, until, operator);
        if (!parser.hasNext() || parser.lookForNext() == until) {
            return first;
        }
        if (operator.goOn(parser)) {
            ArrayList<SignalCondition> conditions = new ArrayList<SignalCondition>();
            conditions.add(first);
            conditions.add(SignalCondition.parseLower(parser, until, operator));
            while (operator.goOn(parser)) {
                conditions.add(SignalCondition.parseLower(parser, until, operator));
            }
            return operator.create(conditions.toArray(new SignalCondition[conditions.size()]));
        }
        return first;
    }

    public static int parseDigit(char current, Parser parser) throws ParseException {
        String digit = "" + current;
        while (Character.isDigit(parser.lookForNext())) {
            digit = digit + parser.next();
        }
        try {
            return Integer.parseInt(digit);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number " + digit, parser.position());
        }
    }

    private static int[] parseInputExact(Parser parser) throws ParseException {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int index = -1;
        boolean first = true;
        while (parser.hasNext()) {
            char current = parser.next();
            if (current == ' ') continue;
            if (current == '}') break;
            if (Character.isDigit(current) || (first || index != -1) && current == '*') {
                if (current == '*') {
                    if (first) {
                        first = false;
                    } else if (index == -1) {
                        throw new ParseException("* is not allowed when index prefix are used", parser.position());
                    }
                    ++index;
                    char next = parser.next();
                    while (next == ' ') {
                        next = parser.next();
                    }
                    if (next == ',') continue;
                    throw new ParseException("Invalid input index=" + index, parser.position());
                }
                int number = SignalCondition.parseDigit(current, parser);
                char next = parser.next();
                if (next == ',') {
                    if (number != 48 && number != 49) {
                        throw new ParseException("Invalid bit value " + number, parser.position());
                    }
                    if (first) {
                        first = false;
                    } else if (index == -1) {
                        throw new ParseException("All entries have to have an index prefix", parser.position());
                    }
                    indexes.add(number == 48 ? -index : ++index);
                    next = parser.next();
                    while (next == ' ') {
                        next = parser.next();
                    }
                    if (next == ',') continue;
                    throw new ParseException("Invalid input index=" + index, parser.position());
                }
                if (next == ':') {
                    int value = SignalCondition.parseDigit(next, parser);
                    if (value != 48 && value != 49) {
                        throw new ParseException("Invalid bit value " + value, parser.position());
                    }
                    if (first) {
                        first = false;
                    } else if (index != -1) {
                        throw new ParseException("No index prefix allowed when they are missing before", parser.position());
                    }
                    indexes.add(number == 48 ? -number : number);
                    next = parser.next();
                    while (next == ' ') {
                        next = parser.next();
                    }
                    if (next == ',') continue;
                    throw new ParseException("Invalid input index=" + index, parser.position());
                }
                throw new ParseException("Invalid input index=" + index, parser.position());
            }
            throw new ParseException("Invalid character in input sequence '" + current + "' " + parser.pattern, parser.position());
        }
        int[] result = new int[indexes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indexes.get(i);
        }
        return result;
    }

    private static SignalConditionInput parseInput(char current, Parser parser) throws ParseException {
        int index = 0;
        if (Character.isDigit(parser.lookForNext())) {
            index = SignalCondition.parseDigit(parser.next(), parser);
        }
        if (current == 'a' || current == 'i') {
            boolean external;
            boolean bl = external = current == 'i';
            if (parser.lookForNext() == '{') {
                return external ? new SignalConditionExternal.SignalConditionExternalExact(index, SignalCondition.parseInputExact(parser)) : new SignalConditionInternal.SignalConditionInternalExact(index, SignalCondition.parseInputExact(parser));
            }
            return external ? new SignalConditionExternal(index) : new SignalConditionInternal(index);
        }
        if (current == 'c') {
            if (parser.lookForNext() == '.') {
                parser.next();
                if (!parser.hasNext()) {
                    throw new ParseException("Invalid end of pattern", parser.position());
                }
                current = parser.next();
                int type = Character.getType(current);
                if (type == 2) {
                    return new SignalConditionChild(index, SignalCondition.parseInput(current, parser));
                }
                if (type == 1) {
                    return new SignalConditionChild(index, SignalCondition.parseInput(Character.toLowerCase(current), parser));
                }
            } else {
                throw new ParseException("Missing dot after child input", parser.position());
            }
        }
        throw new ParseException("Invalid input type " + current, parser.position());
    }

    public abstract void test(LittleStructure var1, boolean[] var2);

    public abstract String write();

    public String toString() {
        return this.write();
    }

    private static enum PatternOperator {
        AND('\n'){

            @Override
            public PatternOperator lower() {
                return null;
            }

            @Override
            public SignalCondition create(SignalCondition[] conditions) {
                return new SignalConditionAND(conditions);
            }
        }
        ,
        OR('+'){

            @Override
            public PatternOperator lower() {
                return AND;
            }

            @Override
            public SignalCondition create(SignalCondition[] conditions) {
                return new SignalConditionOR(conditions);
            }
        }
        ,
        XOR('^'){

            @Override
            public PatternOperator lower() {
                return OR;
            }

            @Override
            public SignalCondition create(SignalCondition[] conditions) {
                return new SignalConditionXOR(conditions);
            }
        };

        public static final PatternOperator HIGHEST;
        public final char operator;

        private PatternOperator(char operator) {
            this.operator = operator;
        }

        public abstract PatternOperator lower();

        public boolean goOn(Parser parser) {
            if (parser.hasNext()) {
                while (parser.lookForNext() == ' ') {
                    parser.next();
                }
                if (this == AND) {
                    char next = parser.lookForNext();
                    return next == '(' || next == '!' || next <= 'z' & next >= 'a';
                }
                if (parser.lookForNext() == this.operator) {
                    parser.next();
                    return true;
                }
            }
            return false;
        }

        public abstract SignalCondition create(SignalCondition[] var1);

        static {
            HIGHEST = XOR;
        }
    }

    public static abstract class SignalConditionInput
    extends SignalCondition {
        public final int childId;

        public SignalConditionInput(int id) {
            this.childId = id;
        }
    }

    public static class SignalConditionNot
    extends SignalCondition {
        public SignalCondition condition;

        public SignalConditionNot(SignalCondition condition) {
            this.condition = condition;
        }

        @Override
        public void test(LittleStructure structure, boolean[] state) {
            this.condition.test(structure, state);
            for (int i = 0; i < state.length; ++i) {
                state[i] = !state[i];
            }
        }

        @Override
        public String write() {
            return "!" + this.condition.write();
        }
    }

    public static class SignalConditionXOR
    extends SignalCondition {
        public SignalCondition[] conditions;

        public SignalConditionXOR(SignalCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public void test(LittleStructure structure, boolean[] state) {
            int i;
            boolean[][] newStates = new boolean[this.conditions.length][state.length];
            for (i = 0; i < this.conditions.length; ++i) {
                this.conditions[i].test(structure, newStates[i]);
            }
            block1: for (i = 0; i < state.length; ++i) {
                boolean oneTrue = false;
                for (int j = 0; j < newStates.length; ++j) {
                    if (newStates[j][i]) {
                        if (!oneTrue) {
                            oneTrue = true;
                        } else {
                            oneTrue = false;
                            continue block1;
                        }
                    }
                    newStates[j][i] = oneTrue;
                }
            }
        }

        @Override
        public String write() {
            String result = "(";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = result + "^";
                }
                result = result + this.conditions[i].write();
            }
            return result + ")";
        }
    }

    public static class Parser {
        public final String pattern;
        private int pos = -1;

        public Parser(String pattern) {
            this.pattern = pattern;
        }

        public boolean hasNext() {
            return this.pos < this.pattern.length() - 1;
        }

        public char next() {
            return this.pattern.charAt(++this.pos);
        }

        public char lookForNext() {
            if (this.hasNext()) {
                return this.pattern.charAt(this.pos + 1);
            }
            return '\n';
        }

        public int position() {
            return this.pos;
        }
    }
}

