/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.jei.ingredient;

import com.github.vfyjxf.jeiutilities.helper.IngredientHelper;
import com.github.vfyjxf.jeiutilities.helper.ReflectionUtils;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.CraftingRecipeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.ingredients.Ingredients;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeInfo<R, I> {
    public static final IIngredientType<RecipeInfo> RECIPE_INFO = () -> RecipeInfo.class;
    public static final String NONE_MARK = "none";
    private final I ingredient;
    private final R result;
    private final String recipeCategoryUid;
    private final int recipeIndex;
    private final boolean isInputMode;
    private final IRecipeWrapper recipeWrapper;

    public static RecipeInfo create(@Nonnull Object ingredient, @Nonnull Object result, String recipeCategoryUid, int recipeIndex, boolean isInputMode, @Nonnull IRecipeWrapper recipeWrapper) {
        ICraftingRecipeWrapper craftingWrapper;
        if (recipeWrapper instanceof ICraftingRecipeWrapper && (craftingWrapper = (ICraftingRecipeWrapper)recipeWrapper).getRegistryName() != null && ingredient instanceof ItemStack && result instanceof ItemStack) {
            return new CraftingRecipeInfo((ItemStack)ingredient, (ItemStack)result, recipeCategoryUid, recipeIndex, isInputMode, craftingWrapper, craftingWrapper.getRegistryName());
        }
        return new RecipeInfo<Object, Object>(ingredient, result, recipeCategoryUid, recipeIndex, isInputMode, recipeWrapper);
    }

    public RecipeInfo(@Nonnull I ingredient, @Nonnull R result, String recipeCategoryUid, int recipeIndex, boolean isInputMode, @Nonnull IRecipeWrapper recipeWrapper) {
        this.ingredient = ingredient;
        this.result = result;
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeIndex = recipeIndex;
        this.isInputMode = isInputMode;
        this.recipeWrapper = recipeWrapper;
    }

    public I getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public R getResult() {
        return this.result;
    }

    public String getRecipeCategoryUid() {
        return this.recipeCategoryUid;
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public IFocus.Mode getMode() {
        return this.isInputMode ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT;
    }

    public boolean isInputMode() {
        return this.isInputMode;
    }

    public IIngredientRenderer<?> getResultIngredientRenderer() {
        return JeiUtilitiesPlugin.ingredientRegistry.getIngredientRenderer(this.result);
    }

    public IRecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    public RecipeInfo<R, I> copy() {
        return new RecipeInfo<R, I>(this.ingredient, this.result, this.recipeCategoryUid, this.recipeIndex, this.isInputMode, this.recipeWrapper);
    }

    public String toString() {
        return "{\"ingredient\":\"" + this.getIngredientString(this.ingredient) + "\",\"result\":\"" + this.getIngredientString(this.result) + "\",\"recipeCategoryUid\":\"" + this.recipeCategoryUid + "\",\"isInputMode\":" + this.isInputMode + ",\"inputs\":" + this.getInputsString() + "}";
    }

    protected <T> String getIngredientString(T ingredient) {
        if (ingredient instanceof ItemStack) {
            return "T:" + ((ItemStack)ingredient).func_77955_b(new NBTTagCompound()).toString().replace("\"", "\\\"");
        }
        return "O:" + IngredientHelper.getUniqueId(ingredient).replace("\"", "\\\"");
    }

    protected String getInputsString() {
        Ingredients recipeIngredients = new Ingredients();
        this.recipeWrapper.getIngredients((IIngredients)recipeIngredients);
        Map allInputs = (Map)ReflectionUtils.getFieldValue(Ingredients.class, recipeIngredients, "inputs");
        ArrayList recipeIngredientUidList = new ArrayList();
        for (List inputsPerType : allInputs.values()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (List inputPerSlot : inputsPerType) {
                if (inputPerSlot.isEmpty()) {
                    arrayList.add(NONE_MARK);
                    continue;
                }
                arrayList.add(IngredientHelper.getUniqueId(inputPerSlot.get(0)));
            }
            recipeIngredientUidList.add(arrayList);
        }
        recipeIngredientUidList.sort((o1, o2) -> Integer.compare(o2.size(), o1.size()));
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (List list : recipeIngredientUidList) {
            builder.append("[");
            for (String ingredientUid : list) {
                builder.append("\"").append(ingredientUid.replace("\"", "\\\"")).append("\",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("],");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }
}

