/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.loaders.recipe.handlers;

import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GTValues;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.items.MetaItems;
import gregtech.loaders.recipe.CraftingComponent;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GCYMMaterialRecipeHandler {
    public static void register() {
        OrePrefix.ingot.addProcessingHandler(PropertyKey.BLAST, GCYMMaterialRecipeHandler::processIngot);
    }

    public static void processIngot(OrePrefix ingotPrefix, @Nonnull Material material, BlastProperty property) {
        int EUt;
        if (material.getMaterialComponents().size() <= 1) {
            return;
        }
        Fluid molten = null;
        if (material.hasProperty(GCYMPropertyKey.ALLOY_BLAST)) {
            molten = ((AlloyBlastProperty)material.getProperty(GCYMPropertyKey.ALLOY_BLAST)).getFluid();
        }
        if (!OrePrefix.ingotHot.doGenerateItem(material) && material.hasProperty(PropertyKey.FLUID)) {
            molten = ((FluidProperty)material.getProperty(PropertyKey.FLUID)).getFluid();
        }
        if (molten == null) {
            return;
        }
        int temperature = material.getBlastTemperature();
        BlastRecipeBuilder builder = ((BlastRecipeBuilder)GCYMRecipeMaps.ALLOY_BLAST_RECIPES.recipeBuilder()).blastFurnaceTemp(temperature);
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)temperature / 100L));
        }
        if ((EUt = property.getEUtOverride()) < 0) {
            EUt = GTValues.VA[2];
        }
        builder.EUt(EUt);
        int outputAmount = 0;
        for (MaterialStack materialStack : material.getMaterialComponents()) {
            if (!materialStack.material.hasProperty(PropertyKey.DUST)) {
                if (materialStack.material.hasProperty(PropertyKey.FLUID)) {
                    return;
                }
                return;
            }
            builder.input(OrePrefix.dust, materialStack.material, (int)materialStack.amount);
            outputAmount = (int)((long)outputAmount + materialStack.amount);
        }
        builder.fluidOutputs(new FluidStack[]{new FluidStack(molten, 144 * outputAmount)});
        duration = (int)((double)duration * ((double)outputAmount * 3.0 / 4.0));
        if (property.getGasTier() != null) {
            RecipeBuilder builderGas = builder.copy();
            FluidStack gas = ((FluidStack)CraftingComponent.EBF_GASES.get(property.getGasTier())).copy();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)builderGas.notConsumable((GTRecipeInput)new IntCircuitIngredient(material.getMaterialComponents().size() + 10))).fluidInputs(new FluidStack[]{new FluidStack(gas, gas.amount * outputAmount)})).duration((int)((double)duration * 0.67))).buildAndRegister();
        }
        ((BlastRecipeBuilder)((BlastRecipeBuilder)builder.notConsumable((GTRecipeInput)new IntCircuitIngredient(material.getMaterialComponents().size()))).duration(duration)).buildAndRegister();
        if (!OrePrefix.ingotHot.doGenerateItem(material)) {
            return;
        }
        RecipeBuilder freezerBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).duration((int)material.getMass() * 3)).notConsumable(MetaItems.SHAPE_MOLD_INGOT.getStackForm())).output(OrePrefix.ingot, material);
        if (temperature >= 5000) {
            freezerBuilder.fluidInputs(new FluidStack[]{Materials.LiquidHelium.getFluid(500)}).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(250)});
        }
        freezerBuilder.buildAndRegister();
    }
}

