/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common;

import gregicality.multiblocks.api.utils.GCYMLog;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.loaders.recipe.GCYMRecipeLoader;
import gregtech.api.block.VariantItemBlock;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gcym")
public class CommonProxy {
    public void preLoad() {
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gcym")) {
            ConfigManager.sync((String)"gcym", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GCYMLog.logger.info("Registering blocks...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)GCYMMetaBlocks.UNIQUE_CASING);
        registry.register((IForgeRegistryEntry)GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GCYMLog.logger.info("Registering Items...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GCYMMetaBlocks.UNIQUE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING, VariantItemBlock::new));
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        return itemBlock;
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GCYMLog.logger.info("Registering recipe low...");
        GCYMRecipeLoader.init();
    }
}

