/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.fluids;

import gregicality.multiblocks.api.fluids.fluidType.GCYMFluidTypes;
import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.MetaFluids;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class GCYMMetaFluids {
    private static final Set<ResourceLocation> fluidSprites = new HashSet<ResourceLocation>();
    public static final ResourceLocation AUTO_GENERATED_MOLTEN_TEXTURE = new ResourceLocation("gcym", "blocks/fluids/fluid.molten.autogenerated");

    public static void init() {
        fluidSprites.add(AUTO_GENERATED_MOLTEN_TEXTURE);
        for (Material material : GregTechAPI.MATERIAL_REGISTRY) {
            GCYMMetaFluids.createMoltenFluid(material);
        }
    }

    public static void createMoltenFluid(@Nonnull Material material) {
        if (!OrePrefix.ingotHot.doGenerateItem(material)) {
            return;
        }
        if (material.getMaterialComponents().size() <= 1) {
            return;
        }
        BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        if (blastProperty == null) {
            return;
        }
        AlloyBlastProperty alloyBlastProperty = (AlloyBlastProperty)material.getProperty(GCYMPropertyKey.ALLOY_BLAST);
        if (alloyBlastProperty == null) {
            return;
        }
        MetaFluids.setMaterialFluidTexture((Material)material, (FluidType)GCYMFluidTypes.MOLTEN, (ResourceLocation)AUTO_GENERATED_MOLTEN_TEXTURE);
        int temperature = blastProperty.getBlastTemperature();
        Fluid fluid = MetaFluids.registerFluid((Material)material, (FluidType)GCYMFluidTypes.MOLTEN, (int)temperature, (boolean)false);
        alloyBlastProperty.setFluid(fluid);
        alloyBlastProperty.setTemperature(blastProperty.getBlastTemperature());
    }

    public static void registerSprites(TextureMap textureMap) {
        for (ResourceLocation spriteLocation : fluidSprites) {
            textureMap.func_174942_a(spriteLocation);
        }
    }
}

