/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command.chunks;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.data.ClaimResult;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class CmdClaimAs
extends CmdBase {
    public CmdClaimAs() {
        super("claim_as", CmdBase.Level.OP);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (ForgeTeam team : Universe.get().getTeams()) {
                if (!team.type.isServer) continue;
                list.add(team.getId());
            }
            return CmdClaimAs.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw FTBLib.error((ICommandSender)sender, (String)"feature_disabled_server", (Object[])new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        ForgeTeam team = CommandUtils.getTeam((ICommandSender)sender, (String)args[0]);
        if (!team.type.isServer) {
            throw FTBUtilities.error(sender, "commands.chunks.claim_as.team_not_server", args[0]);
        }
        int radius = 0;
        if (args.length >= 2) {
            radius = CmdClaimAs.func_175764_a((String)args[1], (int)0, (int)30);
        }
        EntityPlayerMP player = CmdClaimAs.func_71521_c((ICommandSender)sender);
        ForgePlayer p = new ForgePlayer(Universe.get(), UUID.nameUUIDFromBytes("FakePlayerClaimAs".getBytes(StandardCharsets.UTF_8)), "FakePlayerClaimAs");
        p.team = team;
        ChunkDimPos pos = new ChunkDimPos((Entity)player);
        for (int x = -radius; x <= radius; ++x) {
            block5: for (int z = -radius; z <= radius; ++z) {
                ChunkDimPos pos1 = new ChunkDimPos(pos.posX + x, pos.posZ + z, pos.dim);
                ClaimResult result = ClaimedChunks.instance.claimChunk(p, pos1, false);
                if (x != 0 || z != 0) continue;
                switch (result) {
                    case SUCCESS: {
                        Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_MODIFIED, (ITextComponent[])new ITextComponent[]{FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.chunks.chunk_claimed", new Object[0])}).send(server, (EntityPlayer)player);
                        FTBUtilitiesNotifications.updateChunkMessage(player, pos1);
                        continue block5;
                    }
                    case DIMENSION_BLOCKED: {
                        Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_CANT_CLAIM, (ITextComponent[])new ITextComponent[]{FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.chunks.claiming_not_enabled_dim", new Object[0])}).setError().send(server, (EntityPlayer)player);
                        continue block5;
                    }
                    default: {
                        FTBUtilitiesNotifications.sendCantModifyChunk(server, player);
                    }
                }
            }
        }
    }
}

