/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.render;

import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.powertools.machine.capbank.BlockCapBank;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.render.FillGaugeBakery;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class CapBankItemRenderMapper
implements IRenderMapper.IItemRenderMapper.IItemStateMapper,
IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper {
    @Nonnull
    public static final CapBankItemRenderMapper instance = new CapBankItemRenderMapper();

    private CapBankItemRenderMapper() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        IBlockState defaultState = block.func_176223_P();
        states.add(Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.sides)).func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.NONE)), (Object)null));
        CapBankType bankType = CapBankType.getTypeFromMeta(stack.func_77952_i());
        defaultState = defaultState.func_177226_a(CapBankType.KIND, (Comparable)((Object)bankType));
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.DOWN))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f()))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.DOWN))), (Object)null));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemQuadCollector mapItemDynamicOverlayRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        int maxEnergy;
        IEnergyStorage energyItem = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
        if (energyItem != null && (maxEnergy = energyItem.getMaxEnergyStored()) > 0) {
            int energy = energyItem.getEnergyStored();
            FillGaugeBakery gauge = new FillGaugeBakery(BlockCapBank.getGaugeIcon(), (double)energy / (double)maxEnergy);
            if (gauge.canRender()) {
                ItemQuadCollector result = new ItemQuadCollector();
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                gauge.bake(quads);
                result.addQuads(null, quads);
                return result;
            }
        }
        return null;
    }
}

