/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.server;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.invpanel.database.AbstractInventory;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

class NormalInventory
extends AbstractInventory {
    @Nonnull
    private final IItemHandler inv;
    @Nonnull
    private final BlockPos pos;
    private boolean errored = false;

    NormalInventory(@Nonnull IItemHandler inv, @Nonnull BlockPos pos) {
        this.inv = inv;
        this.pos = pos;
    }

    @Override
    public int scanInventory(@Nonnull IInventoryDatabaseServer db) {
        int numSlots;
        int n = numSlots = this.errored ? 0 : this.inv.getSlots();
        if (numSlots < 1) {
            this.setEmpty(db);
            return 0;
        }
        if (numSlots != this.slotKeys.length) {
            this.reset(db, numSlots);
        }
        for (int slot = 0; slot < numSlots; ++slot) {
            this.scanSlot(db, slot);
        }
        return numSlots;
    }

    protected void scanSlot(@Nonnull IInventoryDatabaseServer db, int slot) {
        ItemStack stack = this.inv.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            } else {
                ItemStack extracted = this.inv.extractItem(slot, stack.func_190916_E(), true);
                if (extracted.func_190926_b()) {
                    stack = ItemStack.field_190927_a;
                } else if (extracted.func_77973_b() != stack.func_77973_b()) {
                    stack = ItemStack.field_190927_a;
                } else if (stack.func_190916_E() > stack.func_77976_d()) {
                    if (extracted.func_190916_E() < extracted.func_77976_d()) {
                        stack = extracted.func_77946_l();
                    }
                } else if (extracted.func_190916_E() != stack.func_190916_E()) {
                    stack = ItemStack.field_190927_a;
                }
            }
        }
        this.updateSlot(db, slot, stack);
    }

    @Override
    public int extractItem(@Nonnull IInventoryDatabaseServer db, IServerItemEntry entry, int slot, int count) {
        ItemStack stack = this.inv.extractItem(slot, count, true);
        if (stack.func_190926_b() || db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        ItemStack extracted = this.inv.extractItem(slot, count, false);
        if (extracted.func_190926_b()) {
            Log.error("Inventory at " + this.pos + " implements IItemHandler wrong. extractItem() with and without simulation give different results.");
            this.setEmpty(db);
            this.errored = true;
            return 0;
        }
        this.scanSlot(db, slot);
        return extracted.func_190916_E();
    }

    @Override
    public void markForScanning(@Nonnull BlockPos posIn) {
        if (this.pos.equals((Object)posIn)) {
            this.markForScanning();
        }
    }
}

