/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.invpanel.client.CraftingHelper;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.client.ItemEntry;
import crazypants.enderio.invpanel.init.InvpanelObject;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InventoryPanelRecipeTransferHandler
implements IRecipeTransferHandler {
    private final IModRegistry registry;

    public static void register(IModRegistry registry) {
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new InventoryPanelRecipeTransferHandler(registry), "minecraft.crafting");
        registry.addRecipeCatalyst((Object)new ItemStack(InvpanelObject.blockInventoryPanel.getBlockNN()), new String[]{"minecraft.crafting"});
    }

    private InventoryPanelRecipeTransferHandler(IModRegistry registry) {
        this.registry = registry;
    }

    public Class getContainerClass() {
        return InventoryPanelContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull Container container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!(container instanceof InventoryPanelContainer)) {
            return this.registry.getJeiHelpers().recipeTransferHandlerHelper().createInternalError();
        }
        InventoryPanelContainer invPanelContainer = (InventoryPanelContainer)container;
        if (doTransfer && !invPanelContainer.clearCraftingGrid()) {
            return this.registry.getJeiHelpers().recipeTransferHandlerHelper().createUserErrorWithTooltip("Could not clear crafting grid");
        }
        InventoryDatabaseClient db = ((TileInventoryPanel)invPanelContainer.getTe()).getDatabaseClient();
        if (db == null) {
            return this.registry.getJeiHelpers().recipeTransferHandlerHelper().createInternalError();
        }
        ArrayList<Integer> missingItemSlots = new ArrayList<Integer>();
        NNList[] ingredients = new NNList[9];
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        Map guiIngredients = itemStacks.getGuiIngredients();
        for (int i = 0; i < 9; ++i) {
            List allIng;
            if (!guiIngredients.containsKey(i + 1) || (allIng = ((IGuiIngredient)guiIngredients.get(i + 1)).getAllIngredients()).isEmpty()) continue;
            if (this.containerContainsIngredient(invPanelContainer, allIng) || this.dbContainsIngredient(db, allIng)) {
                ingredients[i] = new NNList((Collection)allIng);
                continue;
            }
            missingItemSlots.add(i + 1);
        }
        if (missingItemSlots.isEmpty()) {
            if (doTransfer) {
                new CraftingHelper(ingredients).refill(invPanelContainer, maxTransfer ? 64 : 1);
            }
            return null;
        }
        return this.registry.getJeiHelpers().recipeTransferHandlerHelper().createUserErrorForSlots(EnderIO.lang.localizeExact("jei.tooltip.error.recipe.transfer.missing"), missingItemSlots);
    }

    private static List<Slot> getInventorySlots(InventoryPanelContainer invPanelContainer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = InventoryPanelContainer.FIRST_INVENTORY_SLOT; i < InventoryPanelContainer.FIRST_INVENTORY_SLOT + InventoryPanelContainer.NUM_INVENTORY_SLOT; ++i) {
            Slot slot = invPanelContainer.func_75139_a(i);
            slots.add(slot);
        }
        return slots;
    }

    private boolean containerContainsIngredient(InventoryPanelContainer invPanelContainer, List<ItemStack> allIng) {
        List<Slot> slots = InventoryPanelRecipeTransferHandler.getInventorySlots(invPanelContainer);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>();
        for (Slot slot : slots) {
            if (!slot.func_75216_d()) continue;
            available.add(slot.func_75211_c());
        }
        IStackHelper sh = this.registry.getJeiHelpers().getStackHelper();
        return sh.containsAnyStack(available, allIng) != null;
    }

    private boolean dbContainsIngredient(InventoryDatabaseClient db, List<ItemStack> allIng) {
        for (ItemStack ing : allIng) {
            ItemEntry lookup = db.lookupItem(ing, null, false);
            if (lookup == null || lookup.getCount() < ing.func_190916_E()) continue;
            return true;
        }
        return false;
    }
}

