/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.alloysmelter;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.recipe.AbstractMachineRecipe;
import crazypants.enderio.base.recipe.BasicManyToOneRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.lookup.TriItemLookup;
import crazypants.enderio.util.Prep;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class AlloyRecipeManager
extends AbstractMachineRecipe {
    @Nonnull
    private static final String NAME = "Alloy Smelter";
    @Nonnull
    private static final AlloyRecipeManager instance = new AlloyRecipeManager();
    @Nonnull
    private TriItemLookup<IManyToOneRecipe> lookup = new TriItemLookup();

    public static AlloyRecipeManager getInstance() {
        return instance;
    }

    private AlloyRecipeManager() {
    }

    @SubscribeEvent
    public static void create(EnderIOLifecycleEvent.PostInit.Pre event) {
        MachineRecipeRegistry.instance.registerRecipe(instance);
    }

    @SubscribeEvent
    public static void remap(EnderIOLifecycleEvent.ModIdMappingEvent event) {
        Log.debug("Rebuilding recipe lookup table");
        Log.debug("Recipe lookup table has been rebuilt with ", instance.rebuild(), " primary entries");
    }

    public void addRecipe(boolean prohibitDupes, @Nonnull NNList<IRecipeInput> input, @Nonnull ItemStack output, int energyCost, float xpChance, @Nonnull RecipeLevel recipeLevel) {
        Recipe recipe = new Recipe(new RecipeOutput(output, 1.0f, xpChance), energyCost, RecipeBonusType.NONE, recipeLevel, (IRecipeInput[])input.toArray((Object[])new IRecipeInput[0]));
        if (prohibitDupes && input.size() > 1) {
            this.addDedupedRecipe(recipe);
        } else if (this.needsSynthetics(recipe)) {
            this.addSyntheticRecipe(recipe);
        } else {
            this.addRecipe(new BasicManyToOneRecipe(recipe));
        }
    }

    private void addDedupedRecipe(@Nonnull Recipe recipe) {
        ItemStack output = recipe.getOutputs()[0].getOutput();
        Log.debug("Beginning de-duping loop for recipe that outputs ", output);
        RecipeOutput recipeOutput = recipe.getOutputs()[0];
        NNList<List<ItemStack>> inputStacks = recipe.getInputStackAlternatives();
        List list0 = inputStacks.size() >= 1 ? (List)inputStacks.get(0) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
        List list1 = inputStacks.size() >= 2 ? (List)inputStacks.get(1) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
        List list2 = inputStacks.size() >= 3 ? (List)inputStacks.get(2) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
        Log.debug("Got these inputs:");
        Log.debug(" slot 0: ", list0);
        Log.debug(" slot 1: ", list1);
        Log.debug(" slot 2: ", list2);
        NNList seen = new NNList();
        Iterator iterator = list0.iterator();
        while (iterator.hasNext()) {
            ItemStack stack0;
            RecipeInput rinp0 = new RecipeInput(stack0, (stack0 = (ItemStack)iterator.next()).func_77952_i() != Short.MAX_VALUE, recipe.getInputs()[0].getMulitplier(), recipe.getInputs()[1].getSlotNumber());
            Iterator iterator2 = list1.iterator();
            while (iterator2.hasNext()) {
                ItemStack stack1;
                RecipeInput rinp1 = new RecipeInput(stack1, (stack1 = (ItemStack)iterator2.next()).func_77952_i() != Short.MAX_VALUE, recipe.getInputs()[1].getMulitplier(), recipe.getInputs()[1].getSlotNumber());
                Iterator iterator3 = list2.iterator();
                while (iterator3.hasNext()) {
                    ItemStack stack2 = (ItemStack)iterator3.next();
                    Tuple t = new Tuple(stack0, stack1, stack2);
                    if (t.isValid() && !seen.contains((Object)t)) {
                        seen.add((Object)t);
                        Log.debug("Found valid combination ", stack0, " / ", stack1, " / ", stack2);
                        this.addRecipe(new BasicManyToOneRecipe(new Recipe(recipeOutput, recipe.getEnergyRequired(), recipe.getBonusType(), recipe.getRecipeLevel(), (IRecipeInput[])new NNList().addIf((Object)rinp0).addIf((Object)rinp1).addIf((Object)(recipe.getInputs().length >= 3 ? new RecipeInput(stack2, stack2.func_77952_i() != Short.MAX_VALUE, recipe.getInputs()[2].getMulitplier(), recipe.getInputs()[2].getSlotNumber()) : null)).toArray((Object[])new IRecipeInput[0]))).setSynthetic());
                        continue;
                    }
                    Log.debug("Skipping invalid combination ", stack0, " / ", stack1, " / ", stack2);
                }
            }
        }
        if (seen.isEmpty()) {
            Log.warn("Splitting alloying recipe for ", output, " into sub-recipes yielded nothing. Something may be wrong with this recipe.");
        } else {
            Log.debug("Split alloying recipe for ", output, " into ", seen.size(), " sub-recipes");
        }
        this.addRecipe(new BasicManyToOneRecipe(recipe).setDedupeInput());
    }

    private void addSyntheticRecipe(@Nonnull Recipe recipe) {
        int er = recipe.getEnergyRequired();
        RecipeBonusType bns = recipe.getBonusType();
        RecipeLevel lvl = recipe.getRecipeLevel();
        RecipeOutput out = recipe.getOutputs()[0];
        IRecipeInput in = recipe.getInputs()[0];
        IRecipeInput in2 = in.copy();
        in2.shrinkStack(-in.getStackSize());
        RecipeOutput out2 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
        out2.getOutput().func_190917_f(out.getOutput().func_190916_E());
        IRecipeInput in3 = in.copy();
        in3.shrinkStack(-in.getStackSize());
        in3.shrinkStack(-in.getStackSize());
        RecipeOutput out3 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
        out3.getOutput().func_190917_f(out.getOutput().func_190916_E());
        out3.getOutput().func_190917_f(out.getOutput().func_190916_E());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, lvl, in.copy(), in.copy(), in.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, lvl, in.copy(), in2.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, lvl, in2.copy(), in.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, lvl, in.copy(), in.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, lvl, in3.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, lvl, in2.copy())).setSynthetic());
        this.addRecipe(new BasicManyToOneRecipe(recipe));
        Log.debug("Created 6 synthetic recipes for " + in.getInput() + " => " + out.getOutput());
    }

    private boolean needsSynthetics(Recipe recipe) {
        return (Boolean)RecipeConfig.createSyntheticRecipes.get() != false && recipe.getInputs().length == 1 && recipe.getInputs()[0].getStackSize() <= recipe.getInputs()[0].getInput().func_77976_d() / 3 && recipe.getOutputs()[0].getOutput().func_190916_E() <= recipe.getOutputs()[0].getOutput().func_77976_d() / 3;
    }

    private void addRecipe(@Nonnull IManyToOneRecipe recipe) {
        this.dupeCheckRecipe(recipe);
        AlloyRecipeManager.addRecipeToLookup(this.lookup, recipe);
        this.addJEIIntegration(recipe);
    }

    private static void addRecipeToLookup(@Nonnull TriItemLookup<IManyToOneRecipe> lookup, @Nonnull IManyToOneRecipe recipe) {
        block7: {
            NNList<List<ItemStack>> list;
            block8: {
                block6: {
                    list = recipe.getInputStackAlternatives();
                    if (list.size() != 3) break block6;
                    for (ItemStack i0 : (List)list.get(0)) {
                        for (ItemStack i1 : (List)list.get(1)) {
                            for (ItemStack i2 : (List)list.get(2)) {
                                lookup.addRecipe(recipe, i0.func_77973_b(), i1.func_77973_b(), i2.func_77973_b());
                                lookup.addRecipe(recipe, i0.func_77973_b(), i2.func_77973_b(), i1.func_77973_b());
                                lookup.addRecipe(recipe, i1.func_77973_b(), i0.func_77973_b(), i2.func_77973_b());
                                lookup.addRecipe(recipe, i1.func_77973_b(), i2.func_77973_b(), i0.func_77973_b());
                                lookup.addRecipe(recipe, i2.func_77973_b(), i0.func_77973_b(), i1.func_77973_b());
                                lookup.addRecipe(recipe, i2.func_77973_b(), i1.func_77973_b(), i0.func_77973_b());
                            }
                        }
                    }
                    break block7;
                }
                if (list.size() != 2) break block8;
                for (ItemStack i0 : (List)list.get(0)) {
                    for (ItemStack i1 : (List)list.get(1)) {
                        lookup.addRecipe(recipe, i0.func_77973_b(), i1.func_77973_b());
                        lookup.addRecipe(recipe, i1.func_77973_b(), i0.func_77973_b());
                    }
                }
                break block7;
            }
            if (list.size() != 1) break block7;
            for (ItemStack i0 : (List)list.get(0)) {
                lookup.addRecipe(recipe, i0.func_77973_b());
            }
        }
    }

    private void addJEIIntegration(@Nonnull IManyToOneRecipe recipe) {
        if (recipe.getInputs().length >= 2 && !recipe.isDedupeInput() && !recipe.isSynthetic()) {
            NNList inputs = new NNList();
            for (int i = 0; i < recipe.getInputs().length; ++i) {
                ItemStack input = recipe.getInputs()[i].getInput();
                Things inputThing = new Things();
                inputThing.add(input);
                inputThing.setSize(input.func_190916_E());
                inputThing.setNbt(input.func_77978_p());
                inputs.add((Object)inputThing);
            }
            ItemStack output = recipe.getOutputs()[0].getOutput().func_77946_l();
            Things outputThing = new Things();
            outputThing.add(output);
            outputThing.setSize(output.func_190916_E());
            outputThing.setNbt(output.func_77978_p());
            TicProxy.registerAlloyRecipe(outputThing, (NNList<Things>)inputs);
        }
    }

    private void dupeCheckRecipe(IRecipe recipe) {
        if (!recipe.isSynthetic()) {
            NNList ins = new NNList();
            for (ItemStack stack : recipe.getInputStacks()) {
                ins.add((Object)new MachineRecipeInput(-1, (ItemStack)NullHelper.notnullM((Object)stack, (String)"NNList iterated with null")));
            }
            IRecipe rec = this.getRecipeForInputs(RecipeLevel.IGNORE, (NNList<MachineRecipeInput>)ins);
            if (rec != null && !rec.isSynthetic()) {
                Log.warn("The supplied recipe " + recipe + " for " + NAME + " may be a duplicate to: " + rec);
            }
        }
    }

    @Override
    public IRecipe getRecipeForInputs(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        for (IManyToOneRecipe rec : this.lookup.getRecipesLMRI(inputs)) {
            if (!machineLevel.canMake(rec.getRecipeLevel()) || !rec.isInputForRecipe(inputs)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        for (IManyToOneRecipe recipe : this.lookup.getRecipes(input.item.func_77973_b())) {
            if (!machineLevel.canMake(recipe.getRecipeLevel())) continue;
            for (IRecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input.item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidRecipeComponents(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<ItemStack> input) {
        for (IManyToOneRecipe recipe : this.lookup.getRecipesL(input)) {
            if (!machineLevel.canMake(recipe.getRecipeLevel()) || !recipe.isValidRecipeComponents(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        for (IManyToOneRecipe recipe : this.lookup) {
            if (recipe.getOutput().func_77973_b() != output.func_77973_b() || recipe.getOutput().func_77952_i() != output.func_77952_i()) continue;
            return recipe.getOutputs()[0].getExperiance();
        }
        return 0.0f;
    }

    @Nonnull
    public NNList<IManyToOneRecipe> getRecipes() {
        NNList result = new NNList();
        for (IManyToOneRecipe recipe : this.lookup) {
            result.add((Object)recipe);
        }
        return result;
    }

    public int rebuild() {
        int count = 0;
        TriItemLookup<IManyToOneRecipe> newLookup = new TriItemLookup<IManyToOneRecipe>();
        NNList.NNIterator<IManyToOneRecipe> iterator = this.lookup.iterator();
        while (iterator.hasNext()) {
            AlloyRecipeManager.addRecipeToLookup(newLookup, (IManyToOneRecipe)iterator.next());
            ++count;
        }
        this.lookup = newLookup;
        return count;
    }

    @Override
    @Nonnull
    public String getUid() {
        return "AlloySmelterRecipe";
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "alloysmelter";
    }

    private static class Tuple {
        @Nonnull
        protected final ItemStack stack0;
        @Nonnull
        protected final ItemStack stack1;
        @Nonnull
        protected final ItemStack stack2;

        Tuple(@Nullable ItemStack stack0, @Nullable ItemStack stack1, @Nullable ItemStack stack2) {
            this.stack0 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack0, Prep.getEmpty()});
            this.stack1 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack1, Prep.getEmpty()});
            this.stack2 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack2, Prep.getEmpty()});
        }

        boolean isValid() {
            return Prep.isValid(this.stack0) && Prep.isValid(this.stack1) && !Tuple.eq(this.stack0, this.stack1) && !Tuple.eq(this.stack0, this.stack2) && !Tuple.eq(this.stack2, this.stack1);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            return this == other || Tuple.eq(this.stack0, other.stack0) && Tuple.eq(this.stack1, other.stack1) && Tuple.eq(this.stack2, other.stack2) || Tuple.eq(this.stack0, other.stack1) && Tuple.eq(this.stack1, other.stack0) && Tuple.eq(this.stack2, other.stack2) || Tuple.eq(this.stack0, other.stack0) && Tuple.eq(this.stack1, other.stack2) && Tuple.eq(this.stack2, other.stack1) || Tuple.eq(this.stack0, other.stack2) && Tuple.eq(this.stack1, other.stack1) && Tuple.eq(this.stack2, other.stack0) || Tuple.eq(this.stack0, other.stack1) && Tuple.eq(this.stack1, other.stack2) && Tuple.eq(this.stack2, other.stack0) || Tuple.eq(this.stack0, other.stack0) && Tuple.eq(this.stack1, other.stack2) && Tuple.eq(this.stack2, other.stack1);
        }

        private static boolean eq(@Nonnull ItemStack a, @Nonnull ItemStack b) {
            return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
        }

        public int hashCode() {
            return this.stack0.hashCode() ^ this.stack1.hashCode() ^ this.stack2.hashCode();
        }
    }
}

