/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.button.TooltipButton;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.PowerItemFilter;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class PowerItemFilterGui
extends AbstractFilterGui {
    private static final int ID_STICKY = FilterGuiUtil.nextButtonId();
    private static final int ID_MORE = FilterGuiUtil.nextButtonId();
    private static final int ID_LEVEL = FilterGuiUtil.nextButtonId();
    @Nonnull
    private final ToggleButton stickyB;
    @Nonnull
    private final TooltipButton modeB;
    @Nonnull
    private final TooltipButton levelB;
    @Nonnull
    private final PowerItemFilter filter;

    public PowerItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn);
        this.filter = (PowerItemFilter)filterIn;
        int butLeft = 13;
        int x = this.getGuiLeft() + butLeft;
        int y = this.getGuiTop() + 34;
        this.stickyB = new ToggleButton((IGuiScreen)this, ID_STICKY, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_ENABLED.get(), Lang.GUI_ITEM_FILTER_STICKY_ENABLED_2.get()});
        this.stickyB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_DISABLED.get()});
        this.stickyB.setPaintSelectedBorder(false);
        this.modeB = new TooltipButton((IGuiScreen)this, ID_MORE, x += 24, y, 40, 20, "");
        this.modeB.setToolTip(new String[]{Lang.GUI_POWER_ITEM_FILTER_COMPARE.get()});
        this.levelB = new TooltipButton((IGuiScreen)this, ID_LEVEL, x += 44, y, 40, 20, "");
        this.levelB.setToolTip(new String[]{Lang.GUI_POWER_ITEM_FILTER_PERCENT.get()});
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        if (this.isStickyModeAvailable) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(this.filter.isSticky());
        }
        switch (this.filter.getMode()) {
            case LESS: {
                this.modeB.field_146126_j = "<";
                break;
            }
            case LESS_EQUAL: {
                this.modeB.field_146126_j = "<=";
                break;
            }
            case EQUAL: {
                this.modeB.field_146126_j = "=";
                break;
            }
            case MORE_EQUAL: {
                this.modeB.field_146126_j = ">=";
                break;
            }
            case MORE: {
                this.modeB.field_146126_j = ">";
                break;
            }
            default: {
                this.modeB.field_146126_j = "??";
            }
        }
        this.levelB.field_146126_j = String.format("%d%%", this.filter.getLevel() * 100 / 4);
        this.modeB.onGuiInit();
        this.levelB.onGuiInit();
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_MORE) {
            this.filter.setMode(this.filter.getMode().next());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_LEVEL) {
            this.filter.setLevel((this.filter.getLevel() + 1) % 5);
            this.sendFilterChange();
        }
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_POWER_ITEM_FILTER.get();
    }
}

