/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.utils.LogHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlaySound
implements IMessage {
    public double x;
    public double y;
    public double z;
    public String sound;
    public String category;
    public float volume;
    public float pitch;
    public boolean distanceDelay;

    public PacketPlaySound() {
    }

    public PacketPlaySound(double x, double y, double z, String sound, String category, float volume, float pitch, boolean distanceDelay) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = distanceDelay;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeFloat((float)this.x);
        bytes.writeFloat((float)this.y);
        bytes.writeFloat((float)this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.sound);
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.category);
        bytes.writeFloat(this.volume);
        bytes.writeFloat(this.pitch);
        bytes.writeBoolean(this.distanceDelay);
    }

    public void fromBytes(ByteBuf bytes) {
        this.x = bytes.readFloat();
        this.y = bytes.readFloat();
        this.z = bytes.readFloat();
        this.sound = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.category = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.volume = bytes.readFloat();
        this.pitch = bytes.readFloat();
        this.distanceDelay = bytes.readBoolean();
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketPlaySound, IMessage> {
        public IMessage handleMessage(PacketPlaySound message, MessageContext ctx) {
            SoundEvent event = DESoundHandler.getSound(message.sound);
            SoundCategory category = SoundCategory.func_187950_a((String)message.category);
            if (event != null) {
                BrandonsCore.proxy.getClientWorld().func_184134_a(message.x, message.y, message.z, event, category, message.volume, message.pitch, message.distanceDelay);
            } else {
                LogHelper.error("Unable to find sound in vanilla or DE's sound events [%s]", message.sound);
            }
            return null;
        }
    }
}

