/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Debugger
extends ItemBCore {
    private static final Map<Integer, String> MODES = new HashMap<Integer, String>();
    private static Random rand = new Random();

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        World world = player.field_70170_p;
        EntityChaosGuardian guardian = (EntityChaosGuardian)((Object)DataUtils.firstMatch((Iterable)world.func_72872_a(EntityChaosGuardian.class, player.func_174813_aQ().func_186662_g(300.0)), entityChaosGuardian -> true));
        if (guardian != null) {
            guardian.func_184226_ay();
            if (entity instanceof EntityCreeper) {
                ((EntityCreeper)entity).func_110163_bv();
            }
            entity.func_184205_a((Entity)guardian, true);
            LogHelper.dev("Success");
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return super.getNBTShareTag(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        double posX = player.field_70165_t - player.field_70165_t % 16.0 + 8.0;
        double posZ = player.field_70161_v - player.field_70161_v % 16.0 + 8.0;
        MODES.clear();
        MODES.put(0, "Complete Crafting");
        MODES.put(1, "Insert RF");
        MODES.put(2, "Extract RF");
        MODES.put(3, "List Particles");
        MODES.put(4, "Recipe");
        MODES.put(5, "Clear");
        MODES.put(6, "Mod Wiki");
        MODES.put(7, "Explode");
        MODES.put(8, "Light");
        this.handleRightClick(itemStack, world, player, hand);
        return super.func_77659_a(world, player, hand);
    }

    public ActionResult<ItemStack> handleRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        int mode = ItemNBTHelper.getInteger((ItemStack)stack, (String)"mode", (int)0);
        if (player.func_70093_af()) {
            if (++mode == MODES.size()) {
                mode = 0;
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(MODES.get(mode)));
            }
            ItemNBTHelper.setInteger((ItemStack)stack, (String)"mode", (int)mode);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        switch (mode) {
            case 0: {
                break;
            }
            case 3: {
                if (!world.field_72995_K) break;
                break;
            }
            case 4: {
                if (world.field_72995_K) break;
                player.openGui((Object)DraconicEvolution.instance, 2016, world, 0, 0, 0);
                break;
            }
            case 6: {
                if (!world.field_72995_K) break;
                this.openWiki();
                break;
            }
            case 7: {
                if (world.field_72995_K) break;
                this.destroyUniverse(player);
                break;
            }
            case 8: {
                if (world.field_72995_K) break;
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int mode = ItemNBTHelper.getInteger((ItemStack)stack, (String)"mode", (int)0);
        switch (mode) {
            case 0: {
                return this.finishCraft(world, pos);
            }
            case 1: 
            case 2: {
                TileEntity tile = world.func_175625_s(pos);
                if (mode == 1 && tile instanceof IEnergyReceiver) {
                    if (!world.field_72995_K) {
                        LogHelper.info(((IEnergyReceiver)tile).receiveEnergy(side, Integer.MAX_VALUE, false));
                    }
                    return EnumActionResult.PASS;
                }
                if (mode != 2 || !(tile instanceof IEnergyProvider)) break;
                if (!world.field_72995_K) {
                    ((IEnergyProvider)tile).extractEnergy(side, Integer.MAX_VALUE, false);
                }
                return EnumActionResult.PASS;
            }
        }
        return this.miscFunctions(stack, player, world, pos, side, hitX, hitY, hitZ, hand, mode);
    }

    public EnumActionResult miscFunctions(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand, int mode) {
        IBlockState state = world.func_180495_p(pos);
        return EnumActionResult.PASS;
    }

    private void openWiki() {
    }

    public EnumActionResult finishCraft(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFusionCraftingCore && !world.field_72995_K) {
            if (((TileFusionCraftingCore)tile).craftingInProgress()) {
                ((TileFusionCraftingCore)tile).craftingStage.value = (short)2000;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    private void destroyUniverse(EntityPlayer player) {
        Fluid pyro;
        IBlockState lava = Blocks.field_150356_k.func_176223_P();
        LogHelper.dev(FluidRegistry.isFluidRegistered((String)"pyrotheum"));
        if (FluidRegistry.isFluidRegistered((String)"pyrotheum") && (pyro = FluidRegistry.getFluid((String)"pyrotheum")).canBePlacedInWorld()) {
            lava = pyro.getBlock().func_176223_P();
        }
        World world = player.field_70170_p;
        world.func_72876_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 8.0f, true);
        int c = 25 + world.field_73012_v.nextInt(25);
        for (int i = 0; i < c; ++i) {
            EntityFallingBlock entity = new EntityFallingBlock(world, (double)((int)player.field_70165_t) + 0.5, (double)((int)player.field_70163_u), (double)((int)player.field_70161_v) + 0.5, lava);
            entity.field_145812_b = 1;
            entity.field_145813_c = false;
            double vMod = 0.5 + 2.0 * world.field_73012_v.nextDouble();
            entity.func_70024_g((world.field_73012_v.nextDouble() - 0.5) * vMod, world.field_73012_v.nextDouble() / 1.5 * vMod, (world.field_73012_v.nextDouble() - 0.5) * vMod);
            world.func_72838_d((Entity)entity);
        }
    }

    static {
        MODES.put(0, "Complete Crafting");
        MODES.put(1, "Insert RF");
        MODES.put(2, "Extract RF");
        MODES.put(3, "List Particles");
        MODES.put(4, "Recipe");
        MODES.put(5, "Clear");
        MODES.put(6, "Mod Wiki");
        MODES.put(7, "Explode");
        MODES.put(8, "Light");
    }
}

