/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModHelper {
    private static Map<String, String> loadedMods = null;
    public static boolean isTConInstalled;
    public static boolean isAvaritiaInstalled;
    public static boolean isRotaryCraftInstalled;
    public static boolean isJEIInstalled;
    public static boolean isBaublesInstalled;
    private static Item cleaver;
    private static Item avaritiaSword;
    private static Item bedrockSword;

    public static void init() {
        isTConInstalled = Loader.isModLoaded((String)"tconstruct");
        isAvaritiaInstalled = Loader.isModLoaded((String)"avaritia");
        isRotaryCraftInstalled = Loader.isModLoaded((String)"rotarycraft");
        isJEIInstalled = Loader.isModLoaded((String)"jei");
        isBaublesInstalled = Loader.isModLoaded((String)"baubles");
    }

    public static boolean isHoldingCleaver(EntityPlayer player) {
        if (!isTConInstalled) {
            return false;
        }
        if (cleaver == null) {
            cleaver = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("tconstruct", "cleaver"));
        }
        return cleaver != null && HandHelper.getItem((EntityPlayer)player, (Item)cleaver) != null;
    }

    public static boolean isHoldingAvaritiaSword(EntityPlayer player) {
        if (!isAvaritiaInstalled) {
            return false;
        }
        if (avaritiaSword == null) {
            avaritiaSword = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Avaritia", "Infinity_Sword"));
        }
        return avaritiaSword != null && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b().equals(avaritiaSword);
    }

    public static boolean isHoldingBedrockSword(EntityPlayer player) {
        if (!isRotaryCraftInstalled) {
            return false;
        }
        if (bedrockSword == null) {
            bedrockSword = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("rotarycraft", "rotarycraft_item_bedsword"));
        }
        return bedrockSword != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(bedrockSword);
    }

    public static boolean canRemoveEnchants(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ResourceLocation registry = stack.func_77973_b().getRegistryName();
        return registry != null && !registry.func_110624_b().equals("tconstruct");
    }

    public static float applyModDamageAdjustments(CustomArmorHandler.ArmorSummery summery, LivingAttackEvent event) {
        EntityPlayer attacker;
        if (summery == null) {
            return event.getAmount();
        }
        EntityPlayer entityPlayer = attacker = event.getSource().func_76346_g() instanceof EntityPlayer ? (EntityPlayer)event.getSource().func_76346_g() : null;
        if (attacker == null) {
            return event.getAmount();
        }
        if (ModHelper.isHoldingAvaritiaSword(attacker)) {
            event.getEntityLiving().field_70172_ad = 0;
            return 300.0f;
        }
        if (ModHelper.isHoldingBedrockSword(attacker)) {
            summery.entropy += 10.0f;
            if (summery.entropy > 100.0f) {
                summery.entropy = 100.0f;
            }
            return Math.max(event.getAmount(), Math.min(50.0f, summery.protectionPoints));
        }
        if (event.getSource().func_76363_c() || event.getSource().func_76357_e()) {
            summery.entropy += 3.0f;
            if (summery.entropy > 100.0f) {
                summery.entropy = 100.0f;
            }
            return event.getAmount() * 2.0f;
        }
        return event.getAmount();
    }

    public static void reloadJEI() {
        if (isJEIInstalled) {
            DEJEIPlugin.reloadJEI();
        }
    }

    public static boolean isWrench(ItemStack stack) {
        String name = String.valueOf(stack.func_77973_b().getRegistryName()).toLowerCase(Locale.ENGLISH);
        return name.contains("wrench") || name.contains("binder") || name.contains("hammer");
    }

    public static Map<String, String> getLoadedMods() {
        if (loadedMods == null) {
            loadedMods = Collections.synchronizedMap(new HashMap());
            for (ModContainer mod : Loader.instance().getModList()) {
                loadedMods.put(mod.getModId(), mod.getName());
            }
        }
        return loadedMods;
    }
}

