/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree;

import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.ModDocContainer;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchContent;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import org.w3c.dom.Element;

public class GuiDocTree {
    private TreeBranchRoot dataRootBranch;
    private GuiModWiki guiWiki;
    private TreeBranchRoot activeBranch;
    public String filterCategory = null;
    public String filterText = null;
    public Map<String, TreeBranchRoot> idToBranchMap = new HashMap<String, TreeBranchRoot>();

    public GuiDocTree(GuiModWiki guiWiki) {
        this.guiWiki = guiWiki;
        this.activeBranch = this.dataRootBranch = new TreeBranchRoot(guiWiki, null, "[Not Loaded]");
    }

    public void reloadData() {
        this.idToBranchMap.clear();
        this.activeBranch = this.dataRootBranch = new TreeBranchRoot(this.guiWiki, null, I18n.func_135052_a((String)"guiwiki.label.mods", (Object[])new Object[0]));
        if (WikiDocManager.projectIntelContainer != null) {
            this.dataRootBranch.branchData = WikiDocManager.projectIntelContainer.getElement("en_US");
            if (this.dataRootBranch.branchData != null) {
                this.dataRootBranch.loadBranchContent();
            }
        }
        String lang = this.guiWiki.field_146297_k.func_135016_M().func_135041_c().func_135034_a();
        for (ModDocContainer modDoc : WikiDocManager.modDocMap.values()) {
            this.generateModBranch(modDoc.getElement(lang), modDoc.modid);
        }
    }

    private void generateModBranch(Element modData, String modid) {
        String modName = modData.getAttribute("modName");
        TreeBranchContent modBranch = new TreeBranchContent(this.guiWiki, this.dataRootBranch, modData, modName);
        modBranch.isModBranch = true;
        modBranch.setBranchID(modid);
        modBranch.loadBranchesXML();
        modBranch.initBranches();
        this.dataRootBranch.addSubBranch(modBranch);
    }

    public TreeBranchRoot getActiveBranch() {
        return this.activeBranch;
    }

    public List<TreeBranchRoot> getActiveList() {
        if (this.activeBranch.subBranches.size() > 0) {
            return this.activeBranch.subBranches;
        }
        if (this.activeBranch.subBranches.size() == 0 && this.activeBranch.parent != null) {
            return this.activeBranch.parent.subBranches;
        }
        return new ArrayList<TreeBranchRoot>();
    }

    public void setActiveBranch(TreeBranchRoot activeBranch) {
        this.activeBranch = activeBranch;
        this.guiWiki.wikiList.reloadList();
        GuiModWiki.activeID = activeBranch.branchID;
        this.guiWiki.contentWindow.setActiveBranch(activeBranch);
    }

    public void reOpenLast() {
        if (!StringUtils.func_151246_b((String)GuiModWiki.activeID) && this.idToBranchMap.containsKey(GuiModWiki.activeID)) {
            this.setActiveBranch(this.idToBranchMap.get(GuiModWiki.activeID));
        }
    }

    public void updateFilter() {
    }
}

