/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki;

import com.brandon3055.brandonscore.utils.Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class WikiConfig {
    public static File configJSON;
    public static volatile int NAV_WINDOW;
    public static volatile int CONTENT_WINDOW;
    public static volatile int MENU_BAR;
    public static volatile int NAV_TEXT;
    public static volatile int TEXT_COLOUR;
    public static volatile String docLocation;
    public static boolean drawEditInfo;
    public static volatile boolean editMode;

    public static void initialize(File wikiFolder) {
        configJSON = new File(wikiFolder, "options.json");
        if (!configJSON.exists()) {
            WikiConfig.save();
        }
        WikiConfig.load();
    }

    public static void load() {
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(configJSON));
            reader.beginObject();
            block20: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "colourNavWindow": {
                        NAV_WINDOW = Utils.parseHex((String)reader.nextString());
                        continue block20;
                    }
                    case "colourContentWindow": {
                        CONTENT_WINDOW = Utils.parseHex((String)reader.nextString());
                        continue block20;
                    }
                    case "colourMenuBar": {
                        MENU_BAR = Utils.parseHex((String)reader.nextString());
                        continue block20;
                    }
                    case "colourNavText": {
                        NAV_TEXT = Utils.parseHex((String)reader.nextString());
                        continue block20;
                    }
                    case "colourText2": {
                        TEXT_COLOUR = Utils.parseHex((String)reader.nextString());
                        continue block20;
                    }
                    case "editMode": {
                        editMode = reader.nextBoolean();
                        continue block20;
                    }
                    case "editTarget": {
                        docLocation = reader.nextString();
                        continue block20;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(configJSON));
            writer.setIndent("\t");
            writer.beginObject();
            writer.name("colourNavWindow").value(Integer.toHexString(NAV_WINDOW));
            writer.name("colourContentWindow").value(Integer.toHexString(CONTENT_WINDOW));
            writer.name("colourMenuBar").value(Integer.toHexString(MENU_BAR));
            writer.name("colourNavText").value(Integer.toHexString(NAV_TEXT));
            writer.name("colourText2").value(Integer.toHexString(TEXT_COLOUR));
            writer.name("editMode").value(editMode);
            writer.name("editTarget").value(docLocation);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        NAV_WINDOW = -12828863;
        CONTENT_WINDOW = -12828863;
        MENU_BAR = -12828863;
        NAV_TEXT = 65535;
        TEXT_COLOUR = 0x8C8C8C;
        docLocation = "[CONFIG]";
        drawEditInfo = true;
        editMode = false;
    }
}

