/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.util;

import jackyy.dimensionaledibles.DimensionalEdibles;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleporterHandler {
    public static void teleport(EntityPlayerMP player, int dim, BlockPos coords, PlayerList playerList) {
        TeleporterHandler.teleport(player, dim, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), playerList);
    }

    public static void teleport(EntityPlayerMP player, int dim, double x, double y, double z, PlayerList playerList) {
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Target dimension was not found, canceling teleport"));
            DimensionalEdibles.logger.error("Dimension {} was not found, canceling teleport for player [{}:{}]", (Object)dim, (Object)player.func_70005_c_(), (Object)player.func_110124_au());
            return;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)dim)) {
            return;
        }
        int oldDim = player.field_71093_bK;
        WorldServer worldServer = playerList.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dim;
        WorldServer worldServer1 = playerList.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldServer.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        TeleporterHandler.teleportEntity((Entity)player, worldServer, worldServer1);
        playerList.func_72375_a(player, worldServer);
        player.field_71135_a.func_147364_a(x + 0.5, y, z + 0.5, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServer1);
        playerList.func_72354_b(player, worldServer1);
        playerList.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dim);
        worldServer1.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.25f, new Random().nextFloat() * 0.4f + 0.8f);
        BlockPos pos = new BlockPos(x, y - 1.0, z);
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 200, false, false));
        }
        if (worldServer1.field_73011_w.getDimension() != 0) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (worldServer1.func_180495_p(pos.func_177982_a(xx, 0, zz)).func_185913_b()) continue;
                    worldServer1.func_175656_a(pos.func_177982_a(xx, 0, zz), Blocks.field_150343_Z.func_176223_P());
                }
            }
        }
        for (int yy = 1; yy <= 3; ++yy) {
            if (!worldServer1.func_180495_p(pos.func_177982_a(0, yy, 0)).func_185913_b()) continue;
            worldServer1.func_175698_g(pos.func_177982_a(0, yy, 0));
        }
    }

    public static void teleportEntity(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider oldProvider = oldWorld.field_73011_w;
        WorldProvider newProvider = newWorld.field_73011_w;
        double moveFactor = oldProvider.getMovementFactor() / newProvider.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("teleporting_player");
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }

    public static NBTTagCompound getModNBTData(EntityPlayer player) {
        NBTTagCompound dimensionCache = (NBTTagCompound)player.getEntityData().func_74781_a("dimensionaledibles");
        if (dimensionCache == null) {
            dimensionCache = new NBTTagCompound();
            player.getEntityData().func_74782_a("dimensionaledibles", (NBTBase)dimensionCache);
        }
        return dimensionCache;
    }

    public static void updateDimPos(EntityPlayer player, int dimension, BlockPos pos) {
        NBTTagCompound dimensionCache = TeleporterHandler.getModNBTData(player);
        NBTTagCompound dimPos = (NBTTagCompound)dimensionCache.func_74781_a("" + dimension);
        if (dimPos == null) {
            dimPos = new NBTTagCompound();
            dimensionCache.func_74782_a("" + dimension, (NBTBase)dimPos);
        }
        dimPos.func_74768_a("x", pos.func_177958_n());
        dimPos.func_74768_a("y", pos.func_177956_o());
        dimPos.func_74768_a("z", pos.func_177952_p());
    }

    public static BlockPos getDimPos(EntityPlayerMP player, int dimension, BlockPos currentPos) {
        BlockPos position;
        NBTTagCompound dimensionCache = TeleporterHandler.getModNBTData((EntityPlayer)player);
        NBTTagCompound dimPos = (NBTTagCompound)dimensionCache.func_74781_a("" + dimension);
        if (dimPos == null) {
            dimPos = new NBTTagCompound();
            dimensionCache.func_74782_a("" + dimension, (NBTBase)dimPos);
        }
        if ((position = new BlockPos(dimPos.func_74762_e("x"), dimPos.func_74762_e("y"), dimPos.func_74762_e("z"))).func_177956_o() <= 0) {
            WorldServer newDimworld = player.field_71133_b.func_184103_al().func_72365_p().func_71218_a(dimension);
            position = dimension == 1 ? newDimworld.func_180504_m() : TeleporterHandler.getValidYSpawnPos((World)newDimworld, currentPos);
        }
        return position;
    }

    public static BlockPos getValidYSpawnPos(World world, BlockPos basePos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(basePos.func_177958_n() / 8, basePos.func_177956_o(), basePos.func_177952_p() / 8);
        BlockPos.MutableBlockPos spawnPosition = new BlockPos.MutableBlockPos(-1, -1, -1);
        int possibleYPosition = 0;
        do {
            if ((possibleYPosition = TeleporterHandler.scanColumn(world, pos.func_177958_n(), pos.func_177952_p(), pos.func_177956_o())) == -1) {
                TeleporterHandler.incrementColumn(pos, basePos);
                continue;
            }
            spawnPosition.func_181079_c(pos.func_177958_n(), possibleYPosition, pos.func_177952_p());
        } while (spawnPosition.func_177956_o() == -1);
        return spawnPosition;
    }

    public static int scanColumn(World world, int x, int z, int targetY) {
        int possibleY = -1;
        for (int currentY = 4; currentY < world.func_72940_L(); ++currentY) {
            BlockPos pos = new BlockPos(x, currentY, z);
            boolean isBlockBelowSolid = world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
            boolean isLegBlockFree = world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos);
            boolean isChestBlockFree = world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos);
            if (!isBlockBelowSolid || !isChestBlockFree || !isLegBlockFree) continue;
            if (possibleY == -1) {
                possibleY = currentY;
                continue;
            }
            if (Math.abs(possibleY - targetY) <= Math.abs(pos.func_177956_o() - targetY)) continue;
            possibleY = currentY;
        }
        return possibleY;
    }

    public static void incrementColumn(BlockPos.MutableBlockPos currentPos, BlockPos originalPos) {
        double tempPosIncrementZ;
        double tempPosIncrementX = originalPos.func_185332_f(currentPos.func_177958_n() + 1, currentPos.func_177956_o(), currentPos.func_177952_p());
        if (tempPosIncrementX > (tempPosIncrementZ = originalPos.func_185332_f(currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p() + 1))) {
            currentPos.func_181079_c(currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p() + 1);
        } else {
            currentPos.func_181079_c(currentPos.func_177958_n() + 1, currentPos.func_177956_o(), currentPos.func_177952_p());
        }
    }
}

