/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.registry;

import jackyy.dimensionaledibles.block.BlockCustomCake;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="dimensionaledibles", name="DimensionalEdibles", category="dimensionaledibles")
public class ModConfig {
    @Config.Comment(value={"The Category for general features of the mod"})
    public static General general = new General();
    @Config.Comment(value={"The category for tweaking behaviors of mod features"})
    public static Tweaks tweaks = new Tweaks();

    @Mod.EventBusSubscriber
    public static class ConfigHolder {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("dimensionaledibles")) {
                ConfigManager.sync((String)"dimensionaledibles", (Config.Type)Config.Type.INSTANCE);
                BlockCustomCake.rebuildCache();
            }
        }
    }

    public static class Tweaks {
        @Config.Comment(value={"The category for dealing with the End Cake"})
        public EndCake endCake = new EndCake();
        @Config.Comment(value={"The category for dealing with the End Apple"})
        public EnderApple enderApple = new EnderApple();
        @Config.Comment(value={"The category for dealing with the Nether Cake"})
        public NetherCake netherCake = new NetherCake();
        @Config.Comment(value={"The category for dealing with the Nether Apple"})
        public NetherApple netherApple = new NetherApple();
        @Config.Comment(value={"The category dealing with the Overworld Cake"})
        public OverworldCake overworldCake = new OverworldCake();
        @Config.Comment(value={"The category for dealing with the Overworld Apple"})
        public OverworldApple overworldApple = new OverworldApple();
        @Config.Comment(value={"The category for dealing with the Island Cake"})
        public IslandCake islandCake = new IslandCake();
        @Config.Comment(value={"The category for defining and modifying a Custom Cake"})
        public CustomEdible customEdible = new CustomEdible();
        @Config.Comment(value={"Set to true to disable the activation of vanilla End Portal."})
        public boolean disableVanillaEndPortal = false;

        public static class CustomEdible {
            @Config.Comment(value={"Set a list of dimensions to add cakes / apples for.", "Format: <Dimension ID>, <Cake / Apple Name>", "Example: 0, Overworld", "Note: \"Cake\" is automatically appended onto the end of the name for cakes."})
            public String[] dimensions = new String[0];
            @Config.Comment(value={"Set a list of custom coordinates used by Custom Cakes / Apples, this is optional.", "Format: <Dimension ID>, <X>, <Y>, <Z>", "Example: 0, 420, 123, -420"})
            public String[] customCoords = new String[0];
            @Config.Comment(value={"Customization of Custom Cake features"})
            public CustomCake customCake = new CustomCake();

            public static class CustomCake {
                @Config.Comment(value={"Set to true to make all Custom Cakes pre-fueled upon placed."})
                public boolean preFueled = false;
                @Config.Comment(value={"Set to true to make all Custom Cakes consume fuel."})
                public boolean consumeFuel = true;
                @Config.Comment(value={"Set the fuel used by Custom Cakes.", "Format: <Dimension ID>, <Fuel Registry Name>", "Example: 0, minecraft:apple"})
                public String[] fuel = new String[0];
            }
        }

        public static class IslandCake
        implements CakeConfig {
            @Config.Comment(value={"Set the fuel used by Island Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:cobblestone";
            @Config.Comment(value={"Set to true to make the Island Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the Island Cake consume fuel."})
            public boolean consumesFuel = true;
            @Config.Comment(value={"The Y-level that the Island Cake will teleport to"})
            @Config.RangeInt(min=1, max=255)
            public int yLevel = 80;
            @Config.Comment(value={"The gap between two islands in regions"})
            @Config.RangeInt(min=2, max=100)
            public int islandGapRegions = 2;
            @Config.Comment(value={"Allow players to create personal islands when on a FTB Team"})
            public boolean allowPersonalIslands = true;
            @Config.Comment(value={"The item that when used on an island cake turns it into a personal island cake"})
            public String personalLockingItem = "minecraft:diamond";
            @Config.Comment(value={"The dimension islands will be created in (dimension has to already exist)"})
            public Integer islandDimension = -2;

            @Override
            public String fuel(int dim) {
                return this.fuel;
            }

            @Override
            public boolean preFueled() {
                return this.preFueled;
            }

            @Override
            public boolean consumesFuel() {
                return this.consumesFuel;
            }

            @Override
            public boolean useCustomCoordinates(int dim) {
                return false;
            }

            @Override
            public CustomCoords customCoords(int dim) {
                return null;
            }
        }

        public static class OverworldApple {
            @Config.Comment(value={"Set to true to make the Overworld Apple teleport players to world spawn.", "Otherwise, it will use the cached position."})
            public boolean useWorldSpawn = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();
        }

        public static class OverworldCake
        implements CakeConfig {
            @Config.Comment(value={"Set the fuel used by Overworld Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:sapling";
            @Config.Comment(value={"Set to true to make the Overworld Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the Overworld Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to make the Overworld Cake teleport players to world spawn.", "Otherwise, it will use the cached position."})
            public boolean useWorldSpawn = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();

            @Override
            public String fuel(int dim) {
                return this.fuel;
            }

            @Override
            public boolean preFueled() {
                return this.preFueled;
            }

            @Override
            public boolean consumesFuel() {
                return this.consumeFuel;
            }

            @Override
            public boolean useCustomCoordinates(int dim) {
                return this.useCustomCoords;
            }

            @Override
            public CustomCoords customCoords(int dim) {
                return this.customCoords;
            }
        }

        public static class NetherApple {
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();
        }

        public static class NetherCake
        implements CakeConfig {
            @Config.Comment(value={"Set the fuel used by Nether Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:obsidian";
            @Config.Comment(value={"Set to true to make the Nether Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the Nether Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();

            @Override
            public String fuel(int dim) {
                return this.fuel;
            }

            @Override
            public boolean preFueled() {
                return this.preFueled;
            }

            @Override
            public boolean consumesFuel() {
                return this.consumeFuel;
            }

            @Override
            public boolean useCustomCoordinates(int dim) {
                return this.useCustomCoords;
            }

            @Override
            public CustomCoords customCoords(int dim) {
                return this.customCoords;
            }
        }

        public static class EnderApple {
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();
        }

        public static class EndCake
        implements CakeConfig {
            @Config.Comment(value={"Set the fuel used by End Cake (Don't change this unless you know what you're doing)."})
            public String fuel = "minecraft:ender_eye";
            @Config.Comment(value={"Set to true to make the End Cake pre-fueled upon placed."})
            public boolean preFueled = false;
            @Config.Comment(value={"Set to true to make the End Cake consume fuel."})
            public boolean consumeFuel = true;
            @Config.Comment(value={"Set to true to use custom coordinates for the teleportation."})
            public boolean useCustomCoords = false;
            @Config.Comment(value={"Define the custom spawn coordinates"})
            public CustomCoords customCoords = new CustomCoords();

            @Override
            public String fuel(int dim) {
                return this.fuel;
            }

            @Override
            public boolean preFueled() {
                return this.preFueled;
            }

            @Override
            public boolean consumesFuel() {
                return this.consumeFuel;
            }

            @Override
            public boolean useCustomCoordinates(int dim) {
                return this.useCustomCoords;
            }

            @Override
            public CustomCoords customCoords(int dim) {
                return this.customCoords;
            }
        }
    }

    public static class CustomCoords {
        @Config.Comment(value={"The X spawn coordinate"})
        public double x = 0.0;
        @Config.RangeDouble(min=0.0, max=255.0)
        @Config.Comment(value={"The Y spawn coordinate"})
        public double y = 64.0;
        @Config.Comment(value={"The Z spawn coordinate"})
        public double z = 0.0;

        public CustomCoords() {
        }

        public CustomCoords(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public BlockPos toBlockPos() {
            return new BlockPos(this.x, this.y, this.z);
        }

        public String toString() {
            return String.format("<%.2f,%.2f,%.2f>", this.x, this.y, this.z);
        }
    }

    public static class General {
        @Config.Comment(value={"Set to true to enable End Cake."})
        public boolean endCake = true;
        @Config.Comment(value={"Set to true to enable Nether Cake."})
        public boolean netherCake = true;
        @Config.Comment(value={"Set to true to enable Overworld Cake."})
        public boolean overworldCake = true;
        @Config.Comment(value={"Set to true to enable custom Cakes."})
        public boolean customCake = true;
        @Config.Comment(value={"Set to true to enable Island Cakes."})
        @Config.RequiresMcRestart
        public boolean islandCake = false;
        @Config.Comment(value={"Set to true to enable Ender Apple."})
        public boolean enderApple = true;
        @Config.Comment(value={"Set to true to enable Nether Apple."})
        public boolean netherApple = true;
        @Config.Comment(value={"Set to true to enable Overworld Apple."})
        public boolean overworldApple = true;
        @Config.Comment(value={"Set to true to enable Custom Apple."})
        public boolean customApple = true;
        @Config.Comment(value={"Required operator level to invalidate stored cake spawning position"})
        @Config.RangeInt(min=1, max=4)
        public int operatorInvalidationLevel = 1;
    }

    public static interface CakeConfig {
        public String fuel(int var1);

        public boolean preFueled();

        public boolean consumesFuel();

        public boolean useCustomCoordinates(int var1);

        public CustomCoords customCoords(int var1);
    }
}

