/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.item;

import jackyy.dimensionaledibles.DimensionalEdibles;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemCustomApple
extends ItemFood {
    public ItemCustomApple() {
        super(4, 0.3f, false);
        this.func_77848_i();
        this.setRegistryName("dimensionaledibles:custom_apple");
        this.func_77655_b("dimensionaledibles.custom_apple");
        this.func_77637_a(DimensionalEdibles.TAB);
    }

    public void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("dimID")) {
            return;
        }
        int dimension = nbt.func_74762_e("dimID");
        int customX = nbt.func_74762_e("x");
        int customY = nbt.func_74762_e("y");
        int customZ = nbt.func_74762_e("z");
        if (world.field_73011_w.getDimension() != dimension && !world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            BlockPos coords = customX != 0 && customY != 0 && customZ != 0 ? new BlockPos(customX, customY, customZ) : TeleporterHandler.getDimPos(playerMP, dimension, player.func_180425_c());
            TeleporterHandler.updateDimPos((EntityPlayer)playerMP, world.field_73011_w.getDimension(), player.func_180425_c());
            TeleporterHandler.teleport(playerMP, dimension, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), playerMP.field_71133_b.func_184103_al());
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 200, false, false));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab) && ModConfig.general.customApple) {
            for (String s : ModConfig.tweaks.customEdible.dimensions) {
                this.parseSubItemsString(s, list);
            }
        }
    }

    private void parseSubItemsString(String s, NonNullList<ItemStack> list) {
        try {
            String[] parts = s.split(",");
            if (parts.length < 2) {
                DimensionalEdibles.logger.error("{} is not a valid input line! Format needs to be: <dimID>, <cakeName>", (Object)s);
                return;
            }
            int dimension = Integer.parseInt(parts[0]);
            if (DimensionManager.isDimensionRegistered((int)dimension)) {
                ItemStack stack = new ItemStack((Item)this);
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                    stack.func_77982_d(nbt);
                }
                nbt.func_74768_a("dimID", dimension);
                nbt.func_74778_a("appleName", parts[1].trim());
                nbt.func_74768_a("x", 0);
                nbt.func_74768_a("y", 0);
                nbt.func_74768_a("z", 0);
                for (String c : ModConfig.tweaks.customEdible.customCoords) {
                    try {
                        String[] coords = c.split(",");
                        if (coords.length < 4) {
                            DimensionalEdibles.logger.error("{} is not a valid input line! Format needs to be: <dimID>, <x>, <y>, <z>", (Object)c);
                            continue;
                        }
                        if (Integer.parseInt(coords[0].trim()) != dimension) continue;
                        nbt.func_74768_a("x", Integer.parseInt(coords[1].trim()));
                        nbt.func_74768_a("y", Integer.parseInt(coords[2].trim()));
                        nbt.func_74768_a("z", Integer.parseInt(coords[3].trim()));
                    }
                    catch (NumberFormatException e) {
                        DimensionalEdibles.logger.error("{} is not a valid line input! The dimension ID needs to be a number!", (Object)c, (Object)e);
                    }
                }
                list.add((Object)stack);
            } else {
                DimensionalEdibles.logger.error("{} is not a valid dimension ID! (Needs to be a number)", (Object)parts[0]);
            }
        }
        catch (NumberFormatException e) {
            DimensionalEdibles.logger.error("{} is not a valid line input! The dimension ID needs to be a number!", (Object)s, (Object)e);
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("appleName")) {
            return "Custom Apple";
        }
        return nbt.func_74779_i("appleName") + " Apple";
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

