/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.config;

import com.ezrol.terry.lib.huffstruct.StructNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.BooleanTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.QuadStateTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class WorldTypeNode
extends StructNode {
    private HashMap<Fields, StructNode> table;
    private Charset utf8;

    public WorldTypeNode(StructNode base) {
        HashMap<String, StructNode> loaded = new HashMap<String, StructNode>();
        this.utf8 = Charset.forName("UTF-8");
        if (base != null && base.getArray() != null) {
            for (StructNode n : base.getArray()) {
                if (n.getArray() == null || n.getArray().size() < 2) continue;
                String key = new String(n.getArray().get(0).getBinaryString(), this.utf8);
                StructNode value = n.getArray().get(1);
                if (value == null) continue;
                loaded.put(key, value);
            }
        }
        this.table = new HashMap();
        for (Fields f : Fields.values()) {
            StructNode current = null;
            if (loaded.containsKey(f.getKey())) {
                current = (StructNode)loaded.get(f.getKey());
            }
            this.table.put(f, (StructNode)f.init.apply(current));
        }
    }

    @Override
    public List<StructNode> getArray() {
        ArrayList<StructNode> map = new ArrayList<StructNode>();
        for (Fields f : Fields.values()) {
            ArrayList<StructNode> pair = new ArrayList<StructNode>();
            pair.add(StructNode.newBinaryString(f.getKey().getBytes(this.utf8)));
            pair.add((StructNode)this.getField(f));
            map.add(StructNode.newArray(pair));
        }
        return map;
    }

    @Override
    public byte[] getBinaryString() {
        return null;
    }

    public <T extends StructNode> T getField(Fields f) {
        return (T)this.table.get((Object)f);
    }

    public static enum Fields {
        WORLD_GENERATOR("worldGenerator", a -> new StringTypeNode((StructNode)a, "default")),
        UUID("uuid", UuidTypeNode::new),
        SEED("seed", a -> new StringTypeNode((StructNode)a, "")),
        CUSTOMIZATION_STRING("customizationString", a -> new StringTypeNode((StructNode)a, "")),
        CONFIGURATION_NAME("configurationName", a -> new StringTypeNode((StructNode)a, "Modded World")),
        CONFIGURATION_DESC("configurationDesc", a -> new StringTypeNode((StructNode)a, "A Generic World")),
        CONFIGURATION_IMAGE("configurationImage", a -> new StringTypeNode((StructNode)a, "")),
        LOCK_WORLD_TYPE("lockWorldType", a -> new BooleanTypeNode((StructNode)a, false)),
        SHOW_IN_LIST("showInList", a -> new BooleanTypeNode((StructNode)a, false)),
        BONUS_CHEST_STATE("bonusChestState", a -> new QuadStateTypeNode((StructNode)a, QuadStateTypeNode.States.STATE_DISABLED)),
        STRUCTURE_STATE("structureState", a -> new QuadStateTypeNode((StructNode)a, QuadStateTypeNode.States.STATE_ENABLED)),
        WORLD_LOAD_COMMANDS("worldLoadCommands", a -> new StringListTypeNode((StructNode)a, new String[0])),
        PACK_MODE("packMode", a -> new StringTypeNode((StructNode)a, "any")),
        DATA_PACKS("dataPacks", a -> new StringListTypeNode((StructNode)a, new String[]{"common"}));

        private final String dictName;
        private final Function<StructNode, StructNode> init;

        private Fields(String nm, Function<StructNode, StructNode> def) {
            this.dictName = nm;
            this.init = def;
        }

        public String getKey() {
            return this.dictName;
        }
    }
}

