/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.lib.huffstruct;

import com.ezrol.terry.lib.huffstruct.StructNode;
import com.ezrol.terry.lib.huffstruct.Tree;
import java.util.LinkedList;
import java.util.List;

public class Huffstruct {
    private byte[] buffer;
    private Byte current;
    private int position;
    private int curbit;
    private static Tree tree = Tree.getInstance();

    private Huffstruct(byte[] buffer) {
        this.buffer = buffer;
        this.current = null;
        this.position = 0;
        this.curbit = 0;
    }

    private void flushByte() {
        if (this.current == null) {
            return;
        }
        if (this.buffer.length < this.position + 1) {
            byte[] tmpBuff = new byte[this.position + 513];
            System.arraycopy(this.buffer, 0, tmpBuff, 0, this.buffer.length);
            this.buffer = tmpBuff;
        }
        this.buffer[this.position] = this.current;
        ++this.position;
        this.current = null;
    }

    private void writeBit(boolean value) {
        if (this.current == null) {
            this.current = 0;
            this.curbit = 0;
        }
        if (value) {
            this.current = (byte)(this.current | 1 << 7 - this.curbit);
        }
        ++this.curbit;
        if (this.curbit >= 8) {
            this.flushByte();
        }
    }

    private void writeCode(int code) {
        String prefix = tree.getPrefix(code);
        if (prefix == null) {
            throw new IndexOutOfBoundsException("Bad code provided: " + code);
        }
        for (char c : prefix.toCharArray()) {
            this.writeBit(c == '1');
        }
    }

    public static byte[] dumpData(StructNode root) {
        Huffstruct processor = new Huffstruct(new byte[512]);
        LinkedList<StructNode> stack = new LinkedList<StructNode>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            StructNode node = (StructNode)stack.pop();
            if (node == null) {
                processor.writeCode(502);
                continue;
            }
            byte[] data = node.getBinaryString();
            if (data != null) {
                processor.writeCode(501);
                for (byte b : data) {
                    processor.writeCode(b & 0xFF);
                }
                processor.writeCode(502);
                continue;
            }
            List<StructNode> array = node.getArray();
            processor.writeCode(500);
            stack.addFirst(null);
            for (int i = array.size() - 1; i >= 0; --i) {
                if (array.get(i) == null) {
                    throw new NullPointerException("Cant serialize null (expected StructNode)");
                }
                stack.addFirst(array.get(i));
            }
        }
        processor.flushByte();
        byte[] tmpBuff = new byte[processor.position];
        System.arraycopy(processor.buffer, 0, tmpBuff, 0, processor.position);
        return tmpBuff;
    }

    private boolean readBit() {
        if (this.current == null) {
            this.current = this.buffer[this.position];
            ++this.position;
            this.curbit = 0;
        }
        byte bit = (byte)((this.current << this.curbit & 0xFF) >> 7);
        ++this.curbit;
        if (this.curbit >= 8) {
            this.current = null;
        }
        return bit == 1;
    }

    private int readCode() {
        String prefix = "";
        do {
            int code;
            if ((code = tree.getCode(prefix = prefix + (this.readBit() ? "1" : "0"))) == -1) continue;
            return code;
        } while (prefix.length() <= 16);
        throw new IndexOutOfBoundsException("Unable to find code for prefix: " + prefix);
    }

    public static StructNode loadData(byte[] dat) {
        Huffstruct processor = new Huffstruct(dat);
        LinkedList<StructNode> stack = new LinkedList<StructNode>();
        boolean inString = false;
        LinkedList<Byte> current = new LinkedList<Byte>();
        stack.addFirst(StructNode.newArray());
        do {
            int code = processor.readCode();
            if (inString) {
                if (code == 502) {
                    inString = false;
                    byte[] ar = new byte[current.size()];
                    int i = 0;
                    while (current.size() > 0) {
                        ar[i] = (Byte)current.removeFirst();
                        ++i;
                    }
                    ((StructNode)stack.peekFirst()).getArray().add(StructNode.newBinaryString(ar));
                    continue;
                }
                if (code >= 256) {
                    throw new IllegalStateException("Unexpected code in byte string: " + Integer.toString(code));
                }
                current.addLast((byte)code);
                continue;
            }
            if (code == 501) {
                inString = true;
                continue;
            }
            if (code == 500) {
                stack.addFirst(StructNode.newArray());
                continue;
            }
            if (code == 502) {
                if (stack.size() < 2) {
                    throw new IllegalStateException("Unexpected Extra Array Termination");
                }
                StructNode completed = (StructNode)stack.pop();
                ((StructNode)stack.peekFirst()).getArray().add(completed);
                continue;
            }
            throw new IllegalStateException("Unexpected Control Code: " + Integer.toString(code));
        } while (inString || stack.size() != 1);
        if (stack.size() == 0) {
            throw new IllegalStateException("Structure has no elements!");
        }
        return ((StructNode)stack.getFirst()).getArray().get(0);
    }
}

