/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.tiles;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.inventory.ContainerTileEntity;
import mustapelto.deepmoblearning.common.inventory.ContainerTrialKeystone;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerTrialKey;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageTrialStart;
import mustapelto.deepmoblearning.common.tiles.TileEntityTickable;
import mustapelto.deepmoblearning.common.tiles.TrialHandler;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import mustapelto.deepmoblearning.common.util.TrialKeyHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityTrialKeystone
extends TileEntityTickable {
    private final ItemHandlerTrialKey trialKeyInventory = new ItemHandlerTrialKey();
    private final TrialHandler trialHandler = new TrialHandler(this);
    private static final String NBT_TRIAL_KEY = "trialKey";
    private static final String NBT_TRIAL_STATE = "trialState";
    private static final String NBT_LEGACY_TRIAL_KEY = "inventory";

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.trialHandler.isTrialActive()) {
                this.trialHandler.runTrial();
                if (this.getTimer() % 300L == 0L) {
                    this.sendBlockUpdate();
                }
            }
            if (this.getTimer() % 100L == 0L) {
                this.func_70296_d();
            }
        }
    }

    public void startTrial() {
        if (this.isTrialActive()) {
            return;
        }
        if (!this.hasTrialKeyInInventory() || !TrialKeyHelper.isAttuned(this.getTrialKeyFromInventory())) {
            return;
        }
        if (!this.isTrialAreaClear()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            DMLPacketHandler.sendToServer(new MessageTrialStart(this));
        } else if (this.trialHandler.startTrial(this.trialKeyInventory.getStackInSlot(0))) {
            this.trialKeyInventory.setStackInSlot(0, ItemStack.field_190927_a);
            this.sendBlockUpdate();
            this.func_70296_d();
        }
    }

    public void stopTrial(boolean abort, boolean sendMessages) {
        this.trialHandler.stopTrial(abort, sendMessages);
    }

    public void onPlayerDied(EntityPlayerMP player) {
        this.trialHandler.onPlayerDied(player);
    }

    public void onMobDied() {
        this.trialHandler.onMobDied();
    }

    public boolean isTrialActive() {
        return this.trialHandler.isTrialActive();
    }

    public boolean isTrialAreaClear() {
        return this.trialHandler.isTrialAreaClear();
    }

    public ImmutableList<TrialAffix> getAffixes() {
        ImmutableList<TrialAffix> affixes = this.trialHandler.getAffixes();
        if (affixes == ImmutableList.of() && this.hasTrialKeyInInventory()) {
            affixes = TrialKeyHelper.getAffixes(this.getTrialKeyFromInventory(), this.func_174877_v(), this.func_145831_w());
        }
        return affixes;
    }

    public int getCurrentWave() {
        return this.trialHandler.getCurrentWave();
    }

    public int getLastWave() {
        return this.trialHandler.getLastWave();
    }

    @Nullable
    public AttunementData getTrialData() {
        return TrialKeyHelper.getAttunement(this.getTrialKeyFromInventory()).orElse(null);
    }

    @Override
    public ContainerTileEntity getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerTrialKeystone(this, inventoryPlayer);
    }

    public ItemStack getTrialKeyFromInventory() {
        return this.trialKeyInventory.getStackInSlot(0);
    }

    public boolean hasTrialKeyInInventory() {
        return ItemStackHelper.isTrialKey(this.getTrialKeyFromInventory());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    @Override
    public ByteBuf getUpdateData() {
        ByteBuf buf = super.getUpdateData();
        return this.trialHandler.getUpdateData(buf);
    }

    @Override
    public void handleUpdateData(ByteBuf buf) {
        super.handleUpdateData(buf);
        this.trialHandler.handleUpdateData(buf);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.trialKeyInventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a(NBT_TRIAL_KEY, (NBTBase)this.trialKeyInventory.serializeNBT());
        compound.func_74782_a(NBT_LEGACY_TRIAL_KEY, (NBTBase)inventory);
        NBTTagCompound trialState = new NBTTagCompound();
        this.trialHandler.writeToNBT(trialState);
        compound.func_74782_a(NBT_TRIAL_STATE, (NBTBase)trialState);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (TileEntityTrialKeystone.isLegacyNBT(compound)) {
            this.trialKeyInventory.deserializeNBT(compound.func_74775_l(NBT_LEGACY_TRIAL_KEY));
            this.trialHandler.resetTrial();
        } else {
            NBTTagCompound inventory = compound.func_74775_l(NBT_LEGACY_TRIAL_KEY);
            this.trialKeyInventory.deserializeNBT(inventory.func_74775_l(NBT_TRIAL_KEY));
            this.trialHandler.readFromNBT(compound.func_74775_l(NBT_TRIAL_STATE));
        }
    }

    private static boolean isLegacyNBT(NBTTagCompound nbt) {
        return !nbt.func_74764_b(NBT_TRIAL_STATE);
    }
}

