/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.items.ItemGlitchIngot;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemGlitchArmor
extends ItemArmor {
    private static final ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)"GLITCH_INFUSED_MATERIAL", (String)"deepmoblearning:glitch_infused", (int)120, (int[])new int[]{3, 8, 6, 3}, (int)15, null, (float)3.0f);

    public ItemGlitchArmor(String name, EntityEquipmentSlot slot) {
        super(material, 0, slot);
        this.setRegistryName(name);
        this.func_77655_b("deepmoblearning." + name);
        this.func_77637_a(DMLRelearned.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String pristineChance = DMLConfig.GLITCH_ARMOR_SETTINGS.GLITCH_ARMOR_PRISTINE_CHANCE + "%";
        String pristineCount = String.valueOf(DMLConfig.GLITCH_ARMOR_SETTINGS.GLITCH_ARMOR_PRISTINE_COUNT);
        tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.glitch_armor.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_armor.tooltip_2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"deepmoblearning.glitch_armor.tooltip_3", (Object[])new Object[]{pristineChance, pristineCount}));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_armor.tooltip_4", (Object[])new Object[0]) + TextFormatting.RESET);
        if (DMLConfig.GLITCH_ARMOR_SETTINGS.GLITCH_CREATIVE_FLIGHT_ENABLED) {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"deepmoblearning.glitch_armor.tooltip_5", (Object[])new Object[0]) + TextFormatting.RESET);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() instanceof ItemGlitchIngot;
    }

    public static boolean isSetEquipped(EntityPlayer player) {
        return ItemStackHelper.isGlitchArmor(player.func_184582_a(EntityEquipmentSlot.HEAD)) && ItemStackHelper.isGlitchArmor(player.func_184582_a(EntityEquipmentSlot.CHEST)) && ItemStackHelper.isGlitchArmor(player.func_184582_a(EntityEquipmentSlot.LEGS)) && ItemStackHelper.isGlitchArmor(player.func_184582_a(EntityEquipmentSlot.FEET));
    }

    public static void dropPristineMatter(World world, BlockPos position, ItemStack dataModel) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= DMLConfig.GLITCH_ARMOR_SETTINGS.GLITCH_ARMOR_PRISTINE_CHANCE) {
            DataModelHelper.getDataModelMetadata(dataModel).ifPresent(metadata -> {
                EntityItem drop = new EntityItem(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), metadata.getPristineMatter());
                drop.func_174869_p();
                world.func_72838_d((Entity)drop);
            });
        }
    }

    public static class ItemGlitchBoots
    extends ItemGlitchArmor {
        public ItemGlitchBoots() {
            super("glitch_infused_boots", EntityEquipmentSlot.FEET);
        }
    }

    public static class ItemGlitchLeggings
    extends ItemGlitchArmor {
        public ItemGlitchLeggings() {
            super("glitch_infused_leggings", EntityEquipmentSlot.LEGS);
        }
    }

    public static class ItemGlitchChestplate
    extends ItemGlitchArmor {
        public ItemGlitchChestplate() {
            super("glitch_infused_chestplate", EntityEquipmentSlot.CHEST);
        }
    }

    public static class ItemGlitchHelmet
    extends ItemGlitchArmor {
        public ItemGlitchHelmet() {
            super("glitch_infused_helmet", EntityEquipmentSlot.HEAD);
        }
    }
}

