/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.client.util.KeyboardHelper;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.inventory.ContainerDeepLearner;
import mustapelto.deepmoblearning.common.items.ItemBase;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDeepLearner
extends ItemBase {
    private int inventorySlot = -999;

    public ItemDeepLearner() {
        super("deep_learner", 1);
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            this.inventorySlot = handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : (handIn == EnumHand.OFF_HAND && playerIn.func_184614_ca().func_77973_b() instanceof ItemAir ? -1 : -999);
            if (this.inventorySlot != -999) {
                playerIn.openGui((Object)DMLRelearned.instance, 0, worldIn, 0, 0, 0);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.deep_learner.hud", (Object[])new Object[0]));
        ImmutableList<ItemStack> containedDataModels = DataModelHelper.getDataModelStacksFromList(ItemDeepLearner.getContainedItems(stack));
        if (containedDataModels.size() > 0) {
            if (!KeyboardHelper.isHoldingSneakKey()) {
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.general.more_info", (Object[])new Object[]{KeyboardHelper.getSneakKeyName()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.deep_learner.contains", (Object[])new Object[0]));
                containedDataModels.forEach(dataModel -> {
                    if (DMLConfig.MISC_SETTINGS.SHOW_TIER_IN_NAME) {
                        tooltip.add(dataModel.func_82833_r());
                    } else {
                        tooltip.add(DataModelHelper.getTierDisplayNameFormatted(dataModel) + " " + dataModel.func_82833_r());
                    }
                });
            }
        }
    }

    public static NonNullList<ItemStack> getContainedItems(ItemStack deepLearner) {
        NonNullList items = NonNullList.func_191197_a((int)ContainerDeepLearner.INTERNAL_SLOTS, (Object)ItemStack.field_190927_a);
        NBTTagList inventory = NBTHelper.getTagList(deepLearner, "inventory");
        if (!inventory.func_82582_d()) {
            for (int i = 0; i < inventory.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = inventory.func_150305_b(i);
                items.set(i, (Object)new ItemStack(tagCompound));
            }
        }
        return items;
    }

    public static void setContainedItems(ItemStack deepLearner, NonNullList<ItemStack> items) {
        NBTTagList inventory = new NBTTagList();
        for (ItemStack stack : items) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            inventory.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("inventory", (NBTBase)inventory);
        deepLearner.func_77982_d(compound);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return TextFormatting.AQUA + super.func_77653_i(stack) + TextFormatting.RESET;
    }
}

