/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.events;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.ServerProxy;
import mustapelto.deepmoblearning.common.items.ItemGlitchArmor;
import mustapelto.deepmoblearning.common.items.ItemGlitchHeart;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class PlayerEventHandler {
    private static final List<UUID> FLYING_PLAYERS = new ArrayList<UUID>();

    @SubscribeEvent
    public static void playerLeftClickedBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item heldItem = stack.func_77973_b();
        World world = event.getWorld();
        Block clickedBlock = world.func_180495_p(event.getPos()).func_177230_c();
        Vec3d hitVector = event.getHitVec();
        if (DMLConfig.MISC_SETTINGS.SOOT_COVERED_REDSTONE_CRAFTING_ENABLED && heldItem instanceof ItemRedstone && clickedBlock == Blocks.field_150402_ci) {
            if (event.getSide() == Side.SERVER) {
                PlayerEventHandler.spawnItemEntity(hitVector, world, DMLRegistry.ITEM_SOOTED_REDSTONE, 1);
                stack.func_190918_g(1);
            } else {
                PlayerEventHandler.createRandomParticles(hitVector, world, ServerProxy.SmokeType.SMOKE);
            }
            event.setCanceled(true);
        }
        if (heldItem instanceof ItemGlitchHeart && clickedBlock == Blocks.field_150343_Z) {
            if (event.getSide() == Side.SERVER) {
                PlayerEventHandler.spawnItemEntity(hitVector, world, DMLRegistry.ITEM_GLITCH_FRAGMENT, 3);
                stack.func_190918_g(1);
            } else {
                PlayerEventHandler.createRandomParticles(hitVector, world, ServerProxy.SmokeType.CYAN);
            }
            event.setCanceled(true);
        }
    }

    private static void spawnItemEntity(Vec3d hitVector, World world, Item itemIn, int amount) {
        EntityItem item = new EntityItem(world, hitVector.field_72450_a, hitVector.field_72448_b + 0.5, hitVector.field_72449_c, new ItemStack(itemIn, amount));
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }

    private static void createRandomParticles(Vec3d hitVector, World world, ServerProxy.SmokeType type) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            DMLRelearned.proxy.spawnSmokeParticle(world, hitVector.field_72450_a + random.nextDouble(-0.4, 0.4), hitVector.field_72448_b + random.nextDouble(-0.1, 0.4), hitVector.field_72449_c + random.nextDouble(-0.4, 0.4), random.nextDouble(-0.08, 0.08), random.nextDouble(-0.08, 0.0), random.nextDouble(-0.08, 0.08), type);
        }
    }

    @SubscribeEvent
    public static void playerTickUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!DMLConfig.GLITCH_ARMOR_SETTINGS.GLITCH_CREATIVE_FLIGHT_ENABLED || event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerCapabilities capabilities = event.player.field_71075_bZ;
        UUID playerUUID = event.player.func_110124_au();
        if (ItemGlitchArmor.isSetEquipped(event.player)) {
            if (!capabilities.field_75101_c) {
                capabilities.field_75101_c = true;
                event.player.func_71016_p();
                if (!FLYING_PLAYERS.contains(playerUUID)) {
                    FLYING_PLAYERS.add(playerUUID);
                }
            }
        } else if (FLYING_PLAYERS.contains(playerUUID)) {
            if (capabilities.field_75101_c && !event.player.func_175149_v() && !event.player.func_184812_l_()) {
                capabilities.field_75101_c = false;
                capabilities.field_75100_b = false;
                event.player.func_71016_p();
            }
            PlayerEventHandler.removeFlyingPlayer(playerUUID);
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEventHandler.removeFlyingPlayer(event.player.func_110124_au());
    }

    private static void removeFlyingPlayer(UUID playerUUID) {
        FLYING_PLAYERS.removeIf(uuid -> uuid.equals(playerUUID));
    }
}

