/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class ModelLivingMatter
implements IModel {
    private final ResourceLocation livingMatterLocation;

    public ModelLivingMatter(ResourceLocation livingMatterLocation) {
        this.livingMatterLocation = livingMatterLocation;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of((Object)this.livingMatterLocation);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        state = ForgeBlockStateV1.Transforms.get((String)"forge:default-item").orElse(state);
        ItemLayerModel model = new ItemLayerModel(ImmutableList.of((Object)this.livingMatterLocation));
        return model.bake(state, format, bakedTextureGetter);
    }

    public static enum LoaderLivingMatter implements ICustomModelLoader
    {
        INSTANCE;

        private final Map<String, ResourceLocation> textureCache = new HashMap<String, ResourceLocation>();
        private final Map<String, ModelLivingMatter> modelCache = new HashMap<String, ModelLivingMatter>();

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("deepmoblearning") && modelLocation.func_110623_a().contains("living_matter");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            String livingMatterId = modelLocation.func_110623_a().substring("living_matter_".length());
            if (!this.modelCache.containsKey(livingMatterId)) {
                ModelLivingMatter model = new ModelLivingMatter(this.textureCache.getOrDefault(livingMatterId, DMLConstants.DefaultModels.LIVING_MATTER));
                this.modelCache.put(livingMatterId, model);
            }
            return this.modelCache.get(livingMatterId);
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.initTextureCache();
        }

        private void initTextureCache() {
            this.textureCache.clear();
            this.textureCache.putAll((Map<String, ResourceLocation>)MetadataManager.getLivingMatterTextures());
            this.modelCache.clear();
        }
    }
}

