/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.trap;

import java.util.ArrayList;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.handler.FakePlayerHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;

public enum TrapType implements IStringSerializable
{
    POISON(0, "poison", Items.field_151070_bp, new AffecterPotion(new PotionEffect(MobEffects.field_76436_u, 100))),
    WEAKNESS(1, "weakness", Items.field_151071_bq, new AffecterPotion(new PotionEffect(MobEffects.field_76437_t, 60))),
    HARMING(2, "harming", Items.field_151040_l, entity -> entity.func_70097_a(DamageSource.field_76376_m, 2.5f)),
    SLOWNESS(3, "slowness", Blocks.field_150425_aM, new AffecterPotion(new PotionEffect(MobEffects.field_76421_d, 60, 2))),
    FIRE(4, "fire", Items.field_151033_d, entity -> entity.func_70015_d(2)),
    WITHER(5, "wither", new ItemStack(FeatureMaterial.itemMaterial, 1, 0), new AffecterPotion(new PotionEffect(MobEffects.field_82731_v, 60))),
    MAIM(6, "maim", Items.field_151156_bN, new AffecterMaim()),
    PLAYER(7, "player", Items.field_151144_bL, entity -> FakePlayerHandler.causePlayerDamage(entity, 2.5f));

    private static String[] nameList;
    public final int meta;
    public final String type;
    public final IAffecter affect;
    public final Object crafting;

    private TrapType(int meta, String name, Object crafting, IAffecter affect) {
        this.meta = meta;
        this.type = name;
        this.crafting = crafting;
        this.affect = affect;
    }

    public String func_176610_l() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public static TrapType fromMeta(int meta) {
        for (TrapType type : TrapType.values()) {
            if (type.meta != meta) continue;
            return type;
        }
        return POISON;
    }

    public static String[] getTypes() {
        if (nameList != null) {
            return nameList;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (TrapType type : TrapType.values()) {
            names.add(type.type);
        }
        nameList = names.toArray(new String[names.size()]);
        return nameList;
    }

    private static class AffecterMaim
    implements IAffecter {
        private AffecterMaim() {
        }

        @Override
        public void apply(EntityLivingBase entity) {
            if (entity.func_110138_aP() > 1.0f && entity.func_184222_aU() && !(entity instanceof EntityPlayer)) {
                IAttributeInstance inst = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                inst.func_111128_a(Math.max(inst.func_111125_b() - 1.0, 1.0));
            } else {
                entity.func_70097_a(DamageSource.field_76380_i, 4.0f);
            }
        }
    }

    private static class AffecterPotion
    implements IAffecter {
        private final PotionEffect effect;

        public AffecterPotion(PotionEffect effect) {
            this.effect = effect;
            this.effect.setCurativeItems(new ArrayList());
        }

        @Override
        public void apply(EntityLivingBase entity) {
            if (entity.func_70660_b(this.effect.func_188419_a()) == null) {
                entity.func_70690_d(new PotionEffect(this.effect));
            }
        }
    }

    static interface IAffecter {
        public void apply(EntityLivingBase var1);
    }
}

