/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Vector2d;

public class IntersectionHelper {
    public static final int EDGE_T_0 = 2;
    public static final int EDGE_S_1 = 4;
    public static final int EDGE_T_1 = 6;
    public static final int EDGE_S_0 = 8;
    public static final int EDGE_EDGE_OFFSET = 2;
    public static final int CORNER_CORNER_OFFSET = 2;
    public static final int CORNER_EDGE_OFFSET = 1;
    public static final Vector2d V00 = new Vector2d(0.0, 0.0);
    public static final Vector2d V01 = new Vector2d(0.0, 1.0);
    public static final Vector2d V10 = new Vector2d(1.0, 0.0);
    public static final Vector2d V11 = new Vector2d(1.0, 1.0);
    public static final Vector2d[] VXX = new Vector2d[]{V00, V01, V11, V10};
    public static final int VXX_STEP_SIZE = 2;
    public static final int NONE = 0;

    public static List<Vector2d> getIntersectionShape(Vector2d[] corners) {
        List<Vector2d> result = new ArrayList<Vector2d>(8);
        Vector2d prev = corners[corners.length - 1];
        Vector2d cur = null;
        int cornerCount = 0;
        int lastIntersectingEdge = 0;
        int firstCornerCount = 0;
        FF ff = new FF();
        for (int ci = 0; ci < corners.length; ++ci) {
            int i;
            double angleCurrent;
            double angleCorner;
            cur = corners[ci];
            ff.reset();
            if (prev.x < 0.0 && cur.x < 0.0 || prev.x > 1.0 && cur.x > 1.0 || prev.y < 0.0 && cur.y < 0.0 || prev.y > 1.0 && cur.y > 1.0) {
                cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 0, ff, prev, cur);
                if (result.isEmpty()) {
                    firstCornerCount = cornerCount;
                }
                prev = cur;
                continue;
            }
            ArrayList<Integer> intersections = new ArrayList<Integer>(2);
            ArrayList<Vector2d> postfix = new ArrayList<Vector2d>(2);
            if (prev.x < 0.0 || prev.x > 1.0) {
                if (prev.y < 0.0 || prev.y > 1.0) {
                    angleCorner = IntersectionHelper.angle(prev, IntersectionHelper.getClosestNormalCorner(prev));
                    if (angleCorner > (angleCurrent = IntersectionHelper.angle(prev, cur))) {
                        if (!(0.0 <= cur.x) || !(cur.x <= 1.0) || cur.y != (double)(!(prev.y < 0.0) ? 1 : 0)) {
                            intersections.add(prev.y < 0.0 ? 8 : 4);
                        }
                    } else if (angleCorner < angleCurrent) {
                        if (!(0.0 <= cur.y) || !(cur.y <= 1.0) || cur.x != (double)(!(prev.x < 0.0) ? 1 : 0)) {
                            intersections.add(prev.x < 0.0 ? 2 : 6);
                        }
                    } else {
                        postfix.add(IntersectionHelper.getClosestNormalCorner(prev));
                    }
                    if (cur.x < 0.0 || cur.x > 1.0 || cur.y < 0.0 || cur.y > 1.0) {
                        angleCorner = IntersectionHelper.angle(prev, IntersectionHelper.getOpositeClosestNormalCorner(prev));
                        if (angleCorner > angleCurrent) {
                            if (!(0.0 <= cur.y) || !(cur.y <= 1.0) || cur.x != (double)(prev.x < 0.0 ? 1 : 0)) {
                                intersections.add(prev.x < 0.0 ? 6 : 2);
                            }
                        } else if (angleCorner < angleCurrent) {
                            if (!(0.0 <= cur.x) || !(cur.x <= 1.0) || cur.y != (double)(prev.y < 0.0 ? 1 : 0)) {
                                intersections.add(prev.y < 0.0 ? 4 : 8);
                            }
                        } else {
                            postfix.add(IntersectionHelper.getOpositeClosestNormalCorner(prev));
                        }
                    }
                } else if (prev.y == 0.0 && cur.y == 0.0 || prev.y == 1.0 && cur.y == 1.0) {
                    if (!(0.0 <= prev.x && prev.x <= 1.0 && 0.0 <= prev.y && prev.y <= 1.0 || prev.x < 0.0 && cur.x == 0.0 || prev.x > 1.0 && cur.x == 1.0)) {
                        postfix.add(IntersectionHelper.getClosestNormalCorner(prev));
                    }
                    if (!(0.0 <= cur.x && cur.x <= 1.0 && 0.0 <= cur.y && cur.y <= 1.0 || cur.x < 0.0 && prev.x == 0.0 || cur.x > 1.0 && prev.x == 1.0)) {
                        postfix.add(IntersectionHelper.getClosestNormalCorner(cur));
                    }
                } else if (prev.x < 0.0 && cur.x != 0.0 || prev.x > 1.0 && cur.x != 1.0) {
                    intersections.add(prev.x < 0.0 ? 2 : 6);
                    if (cur.x < 0.0 || cur.x > 1.0) {
                        if (0.0 <= cur.y && cur.y <= 1.0 && cur.x != (double)(prev.x < 0.0 ? 1 : 0)) {
                            intersections.add(cur.x < 0.0 ? 2 : 6);
                        } else {
                            angleCorner = IntersectionHelper.angle(prev, IntersectionHelper.getClosestNormalCorner(cur));
                            if (angleCorner > (angleCurrent = IntersectionHelper.angle(prev, cur))) {
                                intersections.add(prev.x < 0.0 ? 6 : 2);
                            } else if (angleCorner < angleCurrent) {
                                intersections.add(cur.y < 0.0 ? 8 : 4);
                            } else {
                                postfix.add(IntersectionHelper.getClosestNormalCorner(cur));
                            }
                        }
                    } else if (cur.y < 0.0 || cur.y > 1.0) {
                        intersections.add(cur.y < 0.0 ? 8 : 4);
                    }
                }
            } else if (prev.x == 0.0 && cur.x == 0.0 || prev.x == 1.0 && cur.x == 1.0 || prev.y == 0.0 && cur.y == 0.0 || prev.y == 1.0 && cur.y == 1.0) {
                if (!(prev.x < 0.0 && cur.x == 0.0 || prev.x > 1.0 && cur.x == 1.0 || prev.y < 0.0 && cur.y == 0.0 || prev.y > 1.0 && cur.y == 1.0)) {
                    if (!(0.0 <= prev.x && prev.x <= 1.0 && 0.0 <= prev.y && prev.y <= 1.0 || prev.x < 0.0 && cur.x == 0.0 || prev.x > 1.0 && cur.x == 1.0 || prev.y < 0.0 && cur.y == 0.0 || prev.y > 1.0 && cur.y == 1.0)) {
                        postfix.add(IntersectionHelper.getClosestNormalCorner(prev));
                    }
                    if (!(0.0 <= cur.x && cur.x <= 1.0 && 0.0 <= cur.y && cur.y <= 1.0 || cur.x < 0.0 && prev.x == 0.0 || cur.x > 1.0 && prev.x == 1.0 || cur.y < 0.0 && prev.y == 0.0 || cur.y > 1.0 && prev.y == 1.0)) {
                        postfix.add(IntersectionHelper.getClosestNormalCorner(cur));
                    }
                }
            } else if (prev.y < 0.0 || prev.y > 1.0) {
                if (!(prev.y < 0.0 && cur.y == 0.0 || prev.y > 1.0 && cur.y == 1.0)) {
                    intersections.add(prev.y < 0.0 ? 8 : 4);
                    if (cur.x < 0.0 || cur.x > 1.0) {
                        if (0.0 <= cur.y && cur.y <= 1.0) {
                            intersections.add(cur.x < 0.0 ? 2 : 6);
                        } else {
                            angleCorner = IntersectionHelper.angle(prev, IntersectionHelper.getClosestNormalCorner(cur));
                            if (angleCorner > (angleCurrent = IntersectionHelper.angle(prev, cur))) {
                                intersections.add(cur.x < 0.0 ? 2 : 6);
                            } else if (angleCorner < angleCurrent) {
                                intersections.add(prev.y < 0.0 ? 4 : 8);
                            } else {
                                postfix.add(IntersectionHelper.getClosestNormalCorner(cur));
                            }
                        }
                    } else if (cur.y < 0.0 || cur.y > 1.0) {
                        intersections.add(cur.y < 0.0 ? 8 : 4);
                    }
                }
            } else if (!(cur.x < 0.0 && prev.x == 0.0 || cur.x > 1.0 && prev.x == 1.0 || cur.y < 0.0 && prev.y == 0.0 || cur.y > 1.0 && prev.y == 1.0)) {
                if (cur.x < 0.0 || cur.x > 1.0) {
                    if (cur.y < 0.0 || cur.y > 1.0) {
                        angleCorner = IntersectionHelper.angle(prev, IntersectionHelper.getClosestNormalCorner(cur));
                        if (angleCorner > (angleCurrent = IntersectionHelper.angle(prev, cur))) {
                            intersections.add(cur.x < 0.0 ? 2 : 6);
                        } else if (angleCorner < angleCurrent) {
                            intersections.add(cur.y < 0.0 ? 8 : 4);
                        } else {
                            postfix.add(IntersectionHelper.getClosestNormalCorner(cur));
                        }
                    } else {
                        intersections.add(cur.x < 0.0 ? 2 : 6);
                    }
                } else if (cur.y < 0.0 || cur.y > 1.0) {
                    intersections.add(cur.y < 0.0 ? 8 : 4);
                }
            }
            block7: for (i = 0; i < intersections.size(); ++i) {
                switch ((Integer)intersections.get(i)) {
                    case 8: {
                        if (ff.fs == null) {
                            ff.fs = IntersectionHelper.getSFormulaFrom(prev, cur);
                        }
                        if (IntersectionHelper.isBetween(0.0, 1.0, ff.fs != null ? ff.fs.y : prev.x)) {
                            if (lastIntersectingEdge != 0) {
                                if ((cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 8, ff, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                    IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, 8, cornerCount);
                                }
                                cornerCount = 0;
                                lastIntersectingEdge = 0;
                            }
                            result.add(ff.fs != null ? new Vector2d(ff.fs.y, 0.0) : new Vector2d(prev.x, 0.0));
                            continue block7;
                        }
                        intersections.clear();
                        continue block7;
                    }
                    case 4: {
                        if (ff.fs == null) {
                            ff.fs = IntersectionHelper.getSFormulaFrom(prev, cur);
                        }
                        if (IntersectionHelper.isBetween(0.0, 1.0, ff.fs != null ? ff.fs.x + ff.fs.y : prev.x)) {
                            if (lastIntersectingEdge != 0) {
                                if ((cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 4, ff, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                    IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, 4, cornerCount);
                                }
                                cornerCount = 0;
                                lastIntersectingEdge = 0;
                            }
                            result.add(ff.fs != null ? new Vector2d(ff.fs.x + ff.fs.y, 1.0) : new Vector2d(prev.x, 1.0));
                            continue block7;
                        }
                        intersections.clear();
                        continue block7;
                    }
                    case 2: {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (IntersectionHelper.isBetween(0.0, 1.0, ff.ft != null ? ff.ft.y : prev.y)) {
                            if (lastIntersectingEdge != 0) {
                                if ((cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 2, ff, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                    IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, 2, cornerCount);
                                }
                                cornerCount = 0;
                                lastIntersectingEdge = 0;
                            }
                            result.add(ff.ft != null ? new Vector2d(0.0, ff.ft.y) : new Vector2d(0.0, prev.y));
                            continue block7;
                        }
                        intersections.clear();
                        continue block7;
                    }
                    case 6: {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (IntersectionHelper.isBetween(0.0, 1.0, ff.ft != null ? ff.ft.x + ff.ft.y : prev.y)) {
                            if (lastIntersectingEdge != 0) {
                                if ((cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 6, ff, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                    IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, 6, cornerCount);
                                }
                                cornerCount = 0;
                                lastIntersectingEdge = 0;
                            }
                            result.add(ff.ft != null ? new Vector2d(1.0, ff.ft.x + ff.ft.y) : new Vector2d(1.0, prev.y));
                            continue block7;
                        }
                        intersections.clear();
                    }
                }
            }
            if (!postfix.isEmpty()) {
                if (lastIntersectingEdge != 0) {
                    if (lastIntersectingEdge != 0 && (cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, IntersectionHelper.getEdgeFrom(!result.isEmpty() ? result.get(result.size() - 1) : (Vector2d)postfix.get(0)), ff, prev, cur)) != 0) {
                        IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, IntersectionHelper.getEdgeFrom((Vector2d)postfix.get(0)), cornerCount);
                    }
                    cornerCount = 0;
                    lastIntersectingEdge = 0;
                }
                for (i = 0; i < postfix.size(); ++i) {
                    result.add((Vector2d)postfix.get(i));
                }
            }
            if (0.0 <= cur.x && cur.x <= 1.0 && 0.0 <= cur.y && cur.y <= 1.0) {
                if (lastIntersectingEdge != 0) {
                    cornerCount = cur.x == 0.0 || cur.x == 1.0 || cur.y == 0.0 || cur.y == 1.0 ? (cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, IntersectionHelper.getEdgeFrom(cur), ff, prev, cur)) : (cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, IntersectionHelper.getEdgeFrom(!result.isEmpty() ? result.get(result.size() - 1) : cur), ff, prev, cur));
                    if (cornerCount != 0 && lastIntersectingEdge != 0) {
                        IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, IntersectionHelper.getEdgeFrom(cur), cornerCount);
                    }
                    cornerCount = 0;
                    lastIntersectingEdge = 0;
                }
                result.add(cur);
            } else {
                if (lastIntersectingEdge == 0) {
                    lastIntersectingEdge = IntersectionHelper.getEdgeFrom(!result.isEmpty() ? result.get(result.size() - 1) : prev);
                }
                cornerCount += IntersectionHelper.getCornerCount(lastIntersectingEdge, 0, ff, prev, cur);
                if (result.isEmpty()) {
                    firstCornerCount = cornerCount;
                }
            }
            prev = cur;
        }
        if (firstCornerCount + cornerCount != 0) {
            if (!result.isEmpty()) {
                if (lastIntersectingEdge != 0) {
                    IntersectionHelper.addNormalCorners(result, lastIntersectingEdge, IntersectionHelper.getEdgeFrom(result.get(0)), firstCornerCount + cornerCount);
                }
            } else {
                result = Arrays.asList(VXX);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getCornerCount(int lastIntersectingEdge, int currentIntersectingEdge, FF ff, Vector2d prev, Vector2d cur) {
        if (prev.x < 0.0) {
            if (prev.y < 0.0) {
                if (cur.x > 1.0) {
                    if (cur.y > 1.0) {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (!(ff.ft.y < 0.0)) return 4;
                        return -4;
                    }
                    if (!(cur.y < 0.0)) return -3;
                    return -2;
                }
                if (cur.x >= 0.0) {
                    if (cur.y < 0.0) {
                        return -1;
                    }
                    if (cur.y > 1.0) {
                        return 3;
                    }
                    if (currentIntersectingEdge == 2) {
                        return 2;
                    }
                    if (currentIntersectingEdge == 2) {
                        return 1;
                    }
                    if (currentIntersectingEdge == 1) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 8) {
                        return -1;
                    }
                    if (currentIntersectingEdge != 7) return 0;
                    return -2;
                }
                if (cur.y >= 1.0) {
                    return 2;
                }
                if (!(cur.y > 0.0)) return 0;
                return 1;
            }
            if (prev.y > 1.0) {
                if (cur.x > 1.0) {
                    if (cur.y < 0.0) {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (!(ff.ft.y < 0.0)) return 4;
                        return -4;
                    }
                    if (!(cur.y > 1.0)) return 3;
                    return 2;
                }
                if (cur.x >= 0.0) {
                    if (cur.y < 0.0) {
                        return -3;
                    }
                    if (cur.y > 1.0) {
                        return 1;
                    }
                    if (currentIntersectingEdge == 1) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 2) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 3) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 4) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 5) return 0;
                    return 2;
                }
                if (cur.y <= 0.0) {
                    return -2;
                }
                if (!(cur.y < 1.0)) return 0;
                return -1;
            }
            if (cur.x > 1.0) {
                if (!(cur.y < 0.0)) return 3;
                return -3;
            }
            if (cur.x >= 0.0) {
                if (cur.y < 0.0) {
                    return -2;
                }
                if (cur.y > 1.0) {
                    return 2;
                }
                if (currentIntersectingEdge == 1) {
                    return -1;
                }
                if (currentIntersectingEdge == 2) {
                    return 0;
                }
                if (currentIntersectingEdge != 3) return 0;
                return 1;
            }
            if (cur.y < 0.0) {
                return -1;
            }
            if (!(cur.y > 1.0)) return 0;
            return 1;
        }
        if (prev.x > 1.0) {
            if (prev.y < 0.0) {
                if (cur.x < 0.0) {
                    if (cur.y > 1.0) {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (!(ff.ft.y > 1.0)) return 4;
                        return -4;
                    }
                    if (!(cur.y < 0.0)) return 3;
                    return 2;
                }
                if (cur.x <= 1.0) {
                    if (cur.y < 0.0) {
                        return 1;
                    }
                    if (cur.y > 1.0) {
                        return -3;
                    }
                    if (currentIntersectingEdge == 5) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 6) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 7) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 8) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 0) return 0;
                    return 2;
                }
                if (cur.y > 1.0) {
                    return -2;
                }
                if (!(cur.y >= 0.0)) return 0;
                return -1;
            }
            if (prev.y > 1.0) {
                if (cur.x < 0.0) {
                    if (cur.y < 0.0) {
                        if (ff.ft == null) {
                            ff.ft = IntersectionHelper.getTFormulaFrom(prev, cur);
                        }
                        if (!(ff.ft.y > 1.0)) return 4;
                        return -4;
                    }
                    if (!(cur.y > 1.0)) return -3;
                    return -2;
                }
                if (cur.x <= 1.0) {
                    if (cur.y < 0.0) {
                        return 3;
                    }
                    if (cur.y > 1.0) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 3) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 4) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 5) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 6) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 7) return 0;
                    return 2;
                }
                if (cur.y < 0.0) {
                    return 2;
                }
                if (!(cur.y <= 1.0)) return 0;
                return 1;
            }
            if (cur.x < 0.0) {
                if (cur.y < 0.0) {
                    return 3;
                }
                if (!(cur.y > 1.0)) return 0;
                return -3;
            }
            if (cur.x <= 1.0) {
                if (cur.y < 0.0) {
                    return 2;
                }
                if (cur.y > 1.0) {
                    return -2;
                }
                if (currentIntersectingEdge == 5) {
                    return -1;
                }
                if (currentIntersectingEdge == 7) {
                    return 1;
                }
                if (currentIntersectingEdge != 6) return 0;
                return 0;
            }
            if (cur.y > 1.0) {
                return -1;
            }
            if (!(cur.y < 0.0)) return 0;
            return 1;
        }
        if (prev.y < 0.0) {
            if (cur.x < 0.0) {
                if (cur.y < 0.0) {
                    return 1;
                }
                if (!(cur.y > 1.0)) return 2;
                return 3;
            }
            if (cur.x > 1.0) {
                if (cur.y < 0.0) {
                    return -1;
                }
                if (!(cur.y > 1.0)) return -2;
                return -3;
            }
            if (currentIntersectingEdge == 7) {
                return -1;
            }
            if (currentIntersectingEdge == 8) {
                return 0;
            }
            if (currentIntersectingEdge != 1) return 0;
            return 1;
        }
        if (prev.y > 1.0) {
            if (cur.x < 0.0) {
                if (cur.y < 0.0) {
                    return -3;
                }
                if (!(cur.y > 1.0)) return -2;
                return -1;
            }
            if (cur.x > 1.0) {
                if (cur.y < 0.0) {
                    return 3;
                }
                if (!(cur.y > 1.0)) return 2;
                return 1;
            }
            if (currentIntersectingEdge == 3) {
                return -1;
            }
            if (currentIntersectingEdge == 4) {
                return 0;
            }
            if (currentIntersectingEdge != 5) return 0;
            return 1;
        }
        switch (lastIntersectingEdge) {
            case 0: {
                return 0;
            }
            case 7: {
                if (cur.x < 0.0) {
                    return 2;
                }
                if (cur.x <= 1.0) {
                    return 1;
                }
                if (cur.y > 1.0) {
                    return -2;
                }
                if (!(cur.y >= 0.0)) return 0;
                return -1;
            }
            case 8: {
                if (cur.x < 0.0) {
                    return 1;
                }
                if (!(cur.x > 1.0)) return 0;
                return -1;
            }
            case 3: {
                if (cur.x > 1.0) {
                    return 2;
                }
                if (cur.x >= 0.0) {
                    return 1;
                }
                if (cur.y < 0.0) {
                    return -2;
                }
                if (!(cur.y <= 1.0)) return 0;
                return -1;
            }
            case 4: {
                if (cur.x < 0.0) {
                    return -1;
                }
                if (!(cur.x > 1.0)) return 0;
                return 1;
            }
            case 1: {
                if (cur.y > 1.0) {
                    return 2;
                }
                if (cur.y >= 0.0) {
                    return 1;
                }
                if (cur.x > 1.0) {
                    return -2;
                }
                if (!(cur.x >= 0.0)) return 0;
                return -1;
            }
            case 2: {
                if (cur.y < 0.0) {
                    return -1;
                }
                if (!(cur.y > 1.0)) return 0;
                return 1;
            }
            case 5: {
                if (cur.y < 0.0) {
                    return 2;
                }
                if (cur.y <= 1.0) {
                    return 1;
                }
                if (cur.x < 0.0) {
                    return -2;
                }
                if (!(cur.x <= 1.0)) return 0;
                return -1;
            }
            case 6: {
                if (cur.y < 0.0) {
                    return 1;
                }
                if (!(cur.y > 1.0)) return 0;
                return -1;
            }
        }
        return 0;
    }

    public static void addNormalCorners(List<Vector2d> result, int lastIntersectingEdge, int currentIntersectingEdge, int cornerCount) {
        block11: {
            block10: {
                if (cornerCount <= 0) break block10;
                if (lastIntersectingEdge % 2 == 1) {
                    if (currentIntersectingEdge - lastIntersectingEdge == 2) {
                        return;
                    }
                    ++lastIntersectingEdge;
                }
                if (currentIntersectingEdge % 2 == 1) {
                    --currentIntersectingEdge;
                }
                if (currentIntersectingEdge < lastIntersectingEdge) {
                    currentIntersectingEdge += 2 * VXX.length;
                }
                for (int i = lastIntersectingEdge; i < currentIntersectingEdge; i += 2) {
                    result.add(VXX[(int)(Math.floor(i / 2) % (double)VXX.length)]);
                }
                break block11;
            }
            if (cornerCount >= 0) break block11;
            if (lastIntersectingEdge % 2 == 1) {
                if (currentIntersectingEdge - lastIntersectingEdge == -2) {
                    return;
                }
                --lastIntersectingEdge;
            }
            if (currentIntersectingEdge % 2 == 1) {
                ++currentIntersectingEdge;
            }
            if (lastIntersectingEdge < currentIntersectingEdge) {
                lastIntersectingEdge += 2 * VXX.length;
            }
            int i = lastIntersectingEdge;
            while ((i -= 2) > currentIntersectingEdge) {
                result.add(VXX[(int)(Math.floor(i / 2) % (double)VXX.length)]);
            }
        }
    }

    public static int getEdgeFrom(Vector2d vec) {
        if (vec.x == 0.0) {
            if (vec.y == 0.0) {
                return 1;
            }
            if (vec.y == 1.0) {
                return 3;
            }
            return 2;
        }
        if (vec.x == 1.0) {
            if (vec.y == 0.0) {
                return 7;
            }
            if (vec.y == 1.0) {
                return 5;
            }
            return 6;
        }
        if (vec.y == 0.0) {
            if (vec.x == 0.0) {
                return 9;
            }
            if (vec.x == 1.0) {
                return 7;
            }
            return 8;
        }
        if (vec.y == 1.0) {
            if (vec.x == 0.0) {
                return 3;
            }
            if (vec.x == 1.0) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    public static int getNonantsEdgeFrom(Vector2d vec) {
        if (vec.x <= 0.0) {
            if (vec.y <= 0.0) {
                return 1;
            }
            if (vec.y >= 1.0) {
                return 3;
            }
            return 2;
        }
        if (vec.x >= 1.0) {
            if (vec.y <= 0.0) {
                return 7;
            }
            if (vec.y >= 1.0) {
                return 5;
            }
            return 6;
        }
        if (vec.y <= 0.0) {
            if (vec.x <= 0.0) {
                return 9;
            }
            if (vec.x >= 1.0) {
                return 7;
            }
            return 8;
        }
        if (vec.y >= 1.0) {
            if (vec.x <= 0.0) {
                return 3;
            }
            if (vec.x >= 1.0) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    public static Vector2d getClosestNormalCorner(Vector2d vec) {
        if (vec.x < 0.5) {
            if (vec.y < 0.5) {
                return V00;
            }
            return V01;
        }
        if (vec.y < 0.5) {
            return V10;
        }
        return V11;
    }

    public static Vector2d getOpositeClosestNormalCorner(Vector2d vec) {
        if (vec.x < 0.5) {
            if (vec.y < 0.5) {
                return V11;
            }
            return V10;
        }
        if (vec.y < 0.5) {
            return V01;
        }
        return V00;
    }

    public static boolean isBetween(double min, double max, double vec) {
        return min <= vec && vec <= max;
    }

    public static Vector2d getSFormulaFrom(Vector2d prev, Vector2d cur) {
        if (prev.y == cur.y) {
            return null;
        }
        double a = (cur.x - prev.x) / (cur.y - prev.y);
        double b = prev.x - a * prev.y;
        return new Vector2d(a, b);
    }

    public static Vector2d getTFormulaFrom(Vector2d prev, Vector2d cur) {
        if (prev.x == cur.x) {
            return null;
        }
        double a = (cur.y - prev.y) / (cur.x - prev.x);
        double b = prev.y - a * prev.x;
        return new Vector2d(a, b);
    }

    public static double angle(Vector2d v) {
        if (v.x == 0.0) {
            return 0.0;
        }
        if (v.y == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.abs(v.y) / Math.abs(v.x);
    }

    public static double angle(Vector2d from, Vector2d to) {
        if (from.x == to.x) {
            return 0.0;
        }
        if (from.y == to.y) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.abs(to.y - from.y) / Math.abs(to.x - from.x);
    }

    public static class FF {
        public Vector2d ft;
        public Vector2d fs;

        public void reset() {
            this.ft = null;
            this.fs = null;
        }
    }
}

